/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.jcajce.provider.digest;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.CipherKeyGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.SHA512Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.macs.HMac;
import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.jce.provider.JCEMac;

public class SHA512 {

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new SHA512Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest digest = (Digest)super.clone();
            digest.digest = new SHA512Digest((SHA512Digest)this.digest);
            return digest;
        }
    }

    public static class HashMac
    extends JCEMac {
        public HashMac() {
            super(new HMac(new SHA512Digest()));
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACSHA512", 512, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = SHA512.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("MessageDigest.SHA-512", PREFIX + "$Digest");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest.SHA512", "SHA-512");
            configurableProvider.addAlgorithm("Alg.Alias.MessageDigest." + NISTObjectIdentifiers.id_sha512, "SHA-512");
            this.addHMACAlgorithm(configurableProvider, "SHA512", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
            this.addHMACAlias(configurableProvider, "SHA512", PKCSObjectIdentifiers.id_hmacWithSHA512);
        }
    }
}

