/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.openpgp;

import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.BCPGKey;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.BCPGObject;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.DSASecretBCPGKey;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.RSASecretBCPGKey;
import com.geoxp.oss.jarjar.org.bouncycastle.jce.interfaces.ElGamalPrivateKey;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPException;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPPrivateKey;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPPublicKey;
import java.security.KeyPair;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.Date;

public class PGPKeyPair {
    protected PGPPublicKey pub;
    protected PGPPrivateKey priv;

    public PGPKeyPair(int n, KeyPair keyPair, Date date, String string) throws PGPException, NoSuchProviderException {
        this(n, keyPair.getPublic(), keyPair.getPrivate(), date, string);
    }

    public PGPKeyPair(int n, KeyPair keyPair, Date date) throws PGPException {
        this(n, keyPair.getPublic(), keyPair.getPrivate(), date);
    }

    public PGPKeyPair(int n, PublicKey publicKey, PrivateKey privateKey, Date date, String string) throws PGPException, NoSuchProviderException {
        this(n, publicKey, privateKey, date);
    }

    public PGPKeyPair(int n, PublicKey publicKey, PrivateKey privateKey, Date date) throws PGPException {
        BCPGObject bCPGObject;
        this.pub = new PGPPublicKey(n, publicKey, date);
        switch (this.pub.getAlgorithm()) {
            case 1: 
            case 2: 
            case 3: {
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
                bCPGObject = new RSASecretBCPGKey(rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ());
                break;
            }
            case 17: {
                DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
                bCPGObject = new DSASecretBCPGKey(dSAPrivateKey.getX());
                break;
            }
            case 16: 
            case 20: {
                ElGamalPrivateKey elGamalPrivateKey = (ElGamalPrivateKey)privateKey;
                bCPGObject = new ElGamalSecretBCPGKey(elGamalPrivateKey.getX());
                break;
            }
            default: {
                throw new PGPException("unknown key class");
            }
        }
        this.priv = new PGPPrivateKey(this.pub.getKeyID(), this.pub.getPublicKeyPacket(), (BCPGKey)((Object)bCPGObject));
    }

    public PGPKeyPair(PGPPublicKey pGPPublicKey, PGPPrivateKey pGPPrivateKey) {
        this.pub = pGPPublicKey;
        this.priv = pGPPrivateKey;
    }

    protected PGPKeyPair() {
    }

    public long getKeyID() {
        return this.pub.getKeyID();
    }

    public PGPPublicKey getPublicKey() {
        return this.pub;
    }

    public PGPPrivateKey getPrivateKey() {
        return this.priv;
    }
}

