/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.openpgp;

import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.BCPGInputStream;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.BCPGOutputStream;
import com.geoxp.oss.jarjar.org.bouncycastle.bcpg.OnePassSignaturePacket;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPException;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPPublicKey;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPSignature;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPUtil;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PGPContentVerifier;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SignatureException;

public class PGPOnePassSignature {
    private OnePassSignaturePacket sigPack;
    private int signatureType;
    private PGPContentVerifier verifier;
    private byte lastb;
    private OutputStream sigOut;

    PGPOnePassSignature(BCPGInputStream bCPGInputStream) throws IOException, PGPException {
        this((OnePassSignaturePacket)bCPGInputStream.readPacket());
    }

    PGPOnePassSignature(OnePassSignaturePacket onePassSignaturePacket) throws PGPException {
        this.sigPack = onePassSignaturePacket;
        this.signatureType = onePassSignaturePacket.getSignatureType();
    }

    public void initVerify(PGPPublicKey pGPPublicKey, String string) throws NoSuchProviderException, PGPException {
        this.initVerify(pGPPublicKey, PGPUtil.getProvider(string));
    }

    public void initVerify(PGPPublicKey pGPPublicKey, Provider provider) throws PGPException {
        this.init(new JcaPGPContentVerifierBuilderProvider().setProvider(provider), pGPPublicKey);
    }

    public void init(PGPContentVerifierBuilderProvider pGPContentVerifierBuilderProvider, PGPPublicKey pGPPublicKey) throws PGPException {
        PGPContentVerifierBuilder pGPContentVerifierBuilder = pGPContentVerifierBuilderProvider.get(this.sigPack.getKeyAlgorithm(), this.sigPack.getHashAlgorithm());
        this.verifier = pGPContentVerifierBuilder.build(pGPPublicKey);
        this.lastb = 0;
        this.sigOut = this.verifier.getOutputStream();
    }

    public void update(byte by) throws SignatureException {
        if (this.signatureType == 1) {
            if (by == 13) {
                this.byteUpdate((byte)13);
                this.byteUpdate((byte)10);
            } else if (by == 10) {
                if (this.lastb != 13) {
                    this.byteUpdate((byte)13);
                    this.byteUpdate((byte)10);
                }
            } else {
                this.byteUpdate(by);
            }
            this.lastb = by;
        } else {
            this.byteUpdate(by);
        }
    }

    public void update(byte[] byArray) throws SignatureException {
        if (this.signatureType == 1) {
            for (int i = 0; i != byArray.length; ++i) {
                this.update(byArray[i]);
            }
        } else {
            this.blockUpdate(byArray, 0, byArray.length);
        }
    }

    public void update(byte[] byArray, int n, int n2) throws SignatureException {
        if (this.signatureType == 1) {
            int n3 = n + n2;
            for (int i = n; i != n3; ++i) {
                this.update(byArray[i]);
            }
        } else {
            this.blockUpdate(byArray, n, n2);
        }
    }

    private void byteUpdate(byte by) throws SignatureException {
        try {
            this.sigOut.write(by);
        }
        catch (IOException iOException) {
            throw new SignatureException(iOException.getMessage());
        }
    }

    private void blockUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        try {
            this.sigOut.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException.getMessage());
        }
    }

    public boolean verify(PGPSignature pGPSignature) throws PGPException, SignatureException {
        try {
            this.sigOut.write(pGPSignature.getSignatureTrailer());
            this.sigOut.close();
        }
        catch (IOException iOException) {
            throw new PGPException("unable to add trailer: " + iOException.getMessage(), iOException);
        }
        return this.verifier.verify(pGPSignature.getSignature());
    }

    public long getKeyID() {
        return this.sigPack.getKeyID();
    }

    public int getSignatureType() {
        return this.sigPack.getSignatureType();
    }

    public int getHashAlgorithm() {
        return this.sigPack.getHashAlgorithm();
    }

    public int getKeyAlgorithm() {
        return this.sigPack.getKeyAlgorithm();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        BCPGOutputStream bCPGOutputStream = outputStream instanceof BCPGOutputStream ? (BCPGOutputStream)outputStream : new BCPGOutputStream(outputStream);
        bCPGOutputStream.writePacket(this.sigPack);
    }
}

