/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce;

import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.DefaultJcaJceHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.NamedJcaJceHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.ProviderJcaJceHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPException;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPPrivateKey;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PGPContentSigner;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce.SignatureOutputStream;
import com.geoxp.oss.jarjar.org.bouncycastle.util.io.TeeOutputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;

public class JcaPGPContentSignerBuilder
implements PGPContentSignerBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private JcaPGPDigestCalculatorProviderBuilder digestCalculatorProviderBuilder = new JcaPGPDigestCalculatorProviderBuilder();
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();
    private int hashAlgorithm;
    private SecureRandom random;
    private int keyAlgorithm;

    public JcaPGPContentSignerBuilder(int n, int n2) {
        this.keyAlgorithm = n;
        this.hashAlgorithm = n2;
    }

    public JcaPGPContentSignerBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public JcaPGPContentSignerBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        this.digestCalculatorProviderBuilder.setProvider(provider);
        return this;
    }

    public JcaPGPContentSignerBuilder setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        this.digestCalculatorProviderBuilder.setProvider(string);
        return this;
    }

    public JcaPGPContentSignerBuilder setDigestProvider(Provider provider) {
        this.digestCalculatorProviderBuilder.setProvider(provider);
        return this;
    }

    public JcaPGPContentSignerBuilder setDigestProvider(String string) {
        this.digestCalculatorProviderBuilder.setProvider(string);
        return this;
    }

    public PGPContentSigner build(final int n, final PGPPrivateKey pGPPrivateKey) throws PGPException {
        final PGPDigestCalculator pGPDigestCalculator = this.digestCalculatorProviderBuilder.build().get(this.hashAlgorithm);
        final Signature signature = this.helper.createSignature(this.keyAlgorithm, this.hashAlgorithm);
        try {
            if (this.random != null) {
                signature.initSign(this.keyConverter.getPrivateKey(pGPPrivateKey), this.random);
            } else {
                signature.initSign(this.keyConverter.getPrivateKey(pGPPrivateKey));
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("invalid key.", invalidKeyException);
        }
        return new PGPContentSigner(){

            public int getType() {
                return n;
            }

            public int getHashAlgorithm() {
                return JcaPGPContentSignerBuilder.this.hashAlgorithm;
            }

            public int getKeyAlgorithm() {
                return JcaPGPContentSignerBuilder.this.keyAlgorithm;
            }

            public long getKeyID() {
                return pGPPrivateKey.getKeyID();
            }

            public OutputStream getOutputStream() {
                return new TeeOutputStream(new SignatureOutputStream(signature), pGPDigestCalculator.getOutputStream());
            }

            public byte[] getSignature() {
                try {
                    return signature.sign();
                }
                catch (SignatureException signatureException) {
                    throw new IllegalStateException("unable to create signature");
                }
            }

            public byte[] getDigest() {
                return pGPDigestCalculator.getDigest();
            }
        };
    }
}

