/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce;

import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.DefaultJcaJceHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.NamedJcaJceHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.ProviderJcaJceHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPException;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPPublicKey;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PGPContentVerifier;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce.SignatureOutputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.Signature;
import java.security.SignatureException;

public class JcaPGPContentVerifierBuilderProvider
implements PGPContentVerifierBuilderProvider {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JcaPGPContentVerifierBuilderProvider setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        return this;
    }

    public JcaPGPContentVerifierBuilderProvider setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        return this;
    }

    public PGPContentVerifierBuilder get(int n, int n2) throws PGPException {
        return new JcaPGPContentVerifierBuilder(n, n2);
    }

    private class JcaPGPContentVerifierBuilder
    implements PGPContentVerifierBuilder {
        private int hashAlgorithm;
        private int keyAlgorithm;

        public JcaPGPContentVerifierBuilder(int n, int n2) {
            this.keyAlgorithm = n;
            this.hashAlgorithm = n2;
        }

        public PGPContentVerifier build(final PGPPublicKey pGPPublicKey) throws PGPException {
            final Signature signature = JcaPGPContentVerifierBuilderProvider.this.helper.createSignature(this.keyAlgorithm, this.hashAlgorithm);
            try {
                signature.initVerify(JcaPGPContentVerifierBuilderProvider.this.keyConverter.getPublicKey(pGPPublicKey));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new PGPException("invalid key.", invalidKeyException);
            }
            return new PGPContentVerifier(){

                public int getHashAlgorithm() {
                    return JcaPGPContentVerifierBuilder.this.hashAlgorithm;
                }

                public int getKeyAlgorithm() {
                    return JcaPGPContentVerifierBuilder.this.keyAlgorithm;
                }

                public long getKeyID() {
                    return pGPPublicKey.getKeyID();
                }

                public boolean verify(byte[] byArray) {
                    try {
                        return signature.verify(byArray);
                    }
                    catch (SignatureException signatureException) {
                        throw new IllegalStateException("unable to verify signature");
                    }
                }

                public OutputStream getOutputStream() {
                    return new SignatureOutputStream(signature);
                }
            };
        }
    }
}

