/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce;

import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.DefaultJcaJceHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.NamedJcaJceHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.jcajce.ProviderJcaJceHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPException;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce.PGPUtil;
import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class JcePBESecretKeyEncryptorBuilder {
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private int encAlgorithm;
    private PGPDigestCalculator s2kDigestCalculator;
    private SecureRandom random;

    public JcePBESecretKeyEncryptorBuilder(int n) {
        this(n, new SHA1PGPDigestCalculator());
    }

    public JcePBESecretKeyEncryptorBuilder(int n, PGPDigestCalculator pGPDigestCalculator) {
        this.encAlgorithm = n;
        this.s2kDigestCalculator = pGPDigestCalculator;
    }

    public JcePBESecretKeyEncryptorBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePBESecretKeyEncryptorBuilder setProvider(String string) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string));
        return this;
    }

    public JcePBESecretKeyEncryptorBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public PBESecretKeyEncryptor build(char[] cArray) {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        return new PBESecretKeyEncryptor(this.encAlgorithm, this.s2kDigestCalculator, this.random, cArray){
            private Cipher c;
            private byte[] iv;

            public byte[] encryptKeyData(byte[] byArray, byte[] byArray2, int n, int n2) throws PGPException {
                try {
                    this.c = JcePBESecretKeyEncryptorBuilder.this.helper.createCipher(PGPUtil.getSymmetricCipherName(this.encAlgorithm) + "/CFB/NoPadding");
                    this.c.init(1, (Key)PGPUtil.makeSymmetricKey(this.encAlgorithm, byArray), this.random);
                    this.iv = this.c.getIV();
                    return this.c.doFinal(byArray2, n, n2);
                }
                catch (IllegalBlockSizeException illegalBlockSizeException) {
                    throw new PGPException("illegal block size: " + illegalBlockSizeException.getMessage(), illegalBlockSizeException);
                }
                catch (BadPaddingException badPaddingException) {
                    throw new PGPException("bad padding: " + badPaddingException.getMessage(), badPaddingException);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new PGPException("invalid key: " + invalidKeyException.getMessage(), invalidKeyException);
                }
            }

            public byte[] getCipherIV() {
                return this.iv;
            }
        };
    }
}

