/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.openpgp.operator.jcajce;

import com.geoxp.oss.jarjar.org.bouncycastle.openpgp.PGPException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

class PGPUtil {
    PGPUtil() {
    }

    static String getDigestName(int n) throws PGPException {
        switch (n) {
            case 2: {
                return "SHA1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
            case 3: {
                return "RIPEMD160";
            }
            case 8: {
                return "SHA256";
            }
            case 9: {
                return "SHA384";
            }
            case 10: {
                return "SHA512";
            }
            case 11: {
                return "SHA224";
            }
            case 6: {
                return "TIGER";
            }
        }
        throw new PGPException("unknown hash algorithm tag in getDigestName: " + n);
    }

    static String getSignatureName(int n, int n2) throws PGPException {
        String string;
        switch (n) {
            case 1: 
            case 3: {
                string = "RSA";
                break;
            }
            case 17: {
                string = "DSA";
                break;
            }
            case 16: 
            case 20: {
                string = "ElGamal";
                break;
            }
            default: {
                throw new PGPException("unknown algorithm tag in signature:" + n);
            }
        }
        return PGPUtil.getDigestName(n2) + "with" + string;
    }

    static String getSymmetricCipherName(int n) {
        switch (n) {
            case 0: {
                return null;
            }
            case 2: {
                return "DESEDE";
            }
            case 1: {
                return "IDEA";
            }
            case 3: {
                return "CAST5";
            }
            case 4: {
                return "Blowfish";
            }
            case 5: {
                return "SAFER";
            }
            case 6: {
                return "DES";
            }
            case 7: {
                return "AES";
            }
            case 8: {
                return "AES";
            }
            case 9: {
                return "AES";
            }
            case 10: {
                return "Twofish";
            }
        }
        throw new IllegalArgumentException("unknown symmetric algorithm: " + n);
    }

    public static SecretKey makeSymmetricKey(int n, byte[] byArray) throws PGPException {
        String string;
        switch (n) {
            case 2: {
                string = "DES_EDE";
                break;
            }
            case 1: {
                string = "IDEA";
                break;
            }
            case 3: {
                string = "CAST5";
                break;
            }
            case 4: {
                string = "Blowfish";
                break;
            }
            case 5: {
                string = "SAFER";
                break;
            }
            case 6: {
                string = "DES";
                break;
            }
            case 7: {
                string = "AES";
                break;
            }
            case 8: {
                string = "AES";
                break;
            }
            case 9: {
                string = "AES";
                break;
            }
            case 10: {
                string = "Twofish";
                break;
            }
            default: {
                throw new PGPException("unknown symmetric algorithm: " + n);
            }
        }
        return new SecretKeySpec(byArray, string);
    }
}

