/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.operator.bc;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.CryptoException;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.Signer;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.params.ParametersWithRandom;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.ContentSigner;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.OperatorCreationException;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.RuntimeOperatorException;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.bc.BcSignerOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;

public abstract class BcContentSignerBuilder {
    private SecureRandom random;
    private AlgorithmIdentifier sigAlgId;
    private AlgorithmIdentifier digAlgId;

    public BcContentSignerBuilder(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2) {
        this.sigAlgId = algorithmIdentifier;
        this.digAlgId = algorithmIdentifier2;
    }

    public BcContentSignerBuilder setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public ContentSigner build(AsymmetricKeyParameter asymmetricKeyParameter) throws OperatorCreationException {
        final Signer signer = this.createSigner(this.sigAlgId, this.digAlgId);
        if (this.random != null) {
            signer.init(true, new ParametersWithRandom(asymmetricKeyParameter, this.random));
        } else {
            signer.init(true, asymmetricKeyParameter);
        }
        return new ContentSigner(){
            private BcSignerOutputStream stream;
            {
                this.stream = new BcSignerOutputStream(signer);
            }

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return BcContentSignerBuilder.this.sigAlgId;
            }

            public OutputStream getOutputStream() {
                return this.stream;
            }

            public byte[] getSignature() {
                try {
                    return this.stream.getSignature();
                }
                catch (CryptoException cryptoException) {
                    throw new RuntimeOperatorException("exception obtaining signature: " + cryptoException.getMessage(), cryptoException);
                }
            }
        };
    }

    protected abstract Signer createSigner(AlgorithmIdentifier var1, AlgorithmIdentifier var2) throws OperatorCreationException;
}

