/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.operator.bc;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.ExtendedDigest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.GOST3411Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.MD2Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.MD4Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.MD5Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.RIPEMD128Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.RIPEMD160Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.RIPEMD256Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.SHA1Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.SHA224Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.SHA256Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.SHA384Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.crypto.digests.SHA512Digest;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.OperatorCreationException;

class BcUtil {
    BcUtil() {
    }

    static Digest createDigest(AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        ExtendedDigest extendedDigest;
        if (algorithmIdentifier.getAlgorithm().equals(OIWObjectIdentifiers.idSHA1)) {
            extendedDigest = new SHA1Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha224)) {
            extendedDigest = new SHA224Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha256)) {
            extendedDigest = new SHA256Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha384)) {
            extendedDigest = new SHA384Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha512)) {
            extendedDigest = new SHA512Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.md5)) {
            extendedDigest = new MD5Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.md4)) {
            extendedDigest = new MD4Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(PKCSObjectIdentifiers.md2)) {
            extendedDigest = new MD2Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(CryptoProObjectIdentifiers.gostR3411)) {
            extendedDigest = new GOST3411Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(TeleTrusTObjectIdentifiers.ripemd128)) {
            extendedDigest = new RIPEMD128Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(TeleTrusTObjectIdentifiers.ripemd160)) {
            extendedDigest = new RIPEMD160Digest();
        } else if (algorithmIdentifier.getAlgorithm().equals(TeleTrusTObjectIdentifiers.ripemd256)) {
            extendedDigest = new RIPEMD256Digest();
        } else {
            throw new OperatorCreationException("cannot recognise digest");
        }
        return extendedDigest;
    }
}

