/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.pkcs;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.pkcs.MacData;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.DigestInfo;
import com.geoxp.oss.jarjar.org.bouncycastle.operator.MacCalculator;
import com.geoxp.oss.jarjar.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilder;
import com.geoxp.oss.jarjar.org.bouncycastle.pkcs.PKCSException;
import java.io.IOException;
import java.io.OutputStream;

class MacDataGenerator {
    private PKCS12MacCalculatorBuilder builder;

    MacDataGenerator(PKCS12MacCalculatorBuilder pKCS12MacCalculatorBuilder) {
        this.builder = pKCS12MacCalculatorBuilder;
    }

    public MacData build(char[] cArray, byte[] byArray) throws PKCSException {
        MacCalculator macCalculator = this.builder.build(cArray);
        AlgorithmIdentifier algorithmIdentifier = macCalculator.getAlgorithmIdentifier();
        OutputStream outputStream = macCalculator.getOutputStream();
        try {
            outputStream.write(byArray);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new PKCSException("unable to process data: " + iOException.getMessage(), iOException);
        }
        DigestInfo digestInfo = new DigestInfo(this.builder.getDigestAlgorithmIdentifier(), macCalculator.getMac());
        PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
        return new MacData(digestInfo, pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue());
    }
}

