/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.oss.jarjar.org.bouncycastle.pkcs;

import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1Encodable;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1OctetString;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.ASN1Sequence;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.pkcs.ContentInfo;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.pkcs.MacData;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.pkcs.Pfx;
import com.geoxp.oss.jarjar.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.geoxp.oss.jarjar.org.bouncycastle.pkcs.MacDataGenerator;
import com.geoxp.oss.jarjar.org.bouncycastle.pkcs.PKCS12MacCalculatorBuilderProvider;
import com.geoxp.oss.jarjar.org.bouncycastle.pkcs.PKCSException;
import com.geoxp.oss.jarjar.org.bouncycastle.util.Arrays;
import java.io.IOException;

public class PKCS12PfxPdu {
    private Pfx pfx;

    public PKCS12PfxPdu(Pfx pfx) {
        this.pfx = pfx;
    }

    public ContentInfo[] getContentInfos() {
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(ASN1OctetString.getInstance(this.pfx.getAuthSafe().getContent()).getOctets());
        ContentInfo[] contentInfoArray = new ContentInfo[aSN1Sequence.size()];
        for (int i = 0; i != aSN1Sequence.size(); ++i) {
            contentInfoArray[i] = ContentInfo.getInstance(aSN1Sequence.getObjectAt(i));
        }
        return contentInfoArray;
    }

    public boolean hasMac() {
        return this.pfx.getMacData() != null;
    }

    public boolean isMacValid(PKCS12MacCalculatorBuilderProvider pKCS12MacCalculatorBuilderProvider, char[] cArray) throws PKCSException {
        if (this.hasMac()) {
            MacData macData = this.pfx.getMacData();
            MacDataGenerator macDataGenerator = new MacDataGenerator(pKCS12MacCalculatorBuilderProvider.get(new AlgorithmIdentifier(macData.getMac().getAlgorithmId().getAlgorithm(), (ASN1Encodable)new PKCS12PBEParams(macData.getSalt(), macData.getIterationCount().intValue()))));
            try {
                MacData macData2 = macDataGenerator.build(cArray, ASN1OctetString.getInstance(this.pfx.getAuthSafe().getContent()).getOctets());
                return Arrays.constantTimeAreEqual(macData2.getEncoded(), this.pfx.getMacData().getEncoded());
            }
            catch (IOException iOException) {
                throw new PKCSException("unable to process AuthSafe: " + iOException.getMessage());
            }
        }
        throw new IllegalStateException("no MAC present on PFX");
    }

    public Pfx toASN1Structure() {
        return this.pfx;
    }
}

