/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp;

import com.geoxp.geo.Coverage;
import com.geoxp.geo.CoverageHelper;
import com.geoxp.geo.HHCodeHelper;
import com.geoxp.geo.JTSHelper;
import com.vividsolutions.jts.geom.Geometry;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeoXPLib {
    private static final long[] LOWER_BITS = new long[16];

    public static long toGeoXPPoint(double d, double d2) {
        return HHCodeHelper.getHHCodeValue(d, d2);
    }

    public static long toGeoXPPoint(long l, long l2) {
        return HHCodeHelper.buildHHCode(l, l2, 32);
    }

    public static long centerGeoXPPoint(long l, int n) {
        return HHCodeHelper.getCenter(l, n);
    }

    public static double[] fromGeoXPPoint(long l) {
        return HHCodeHelper.getLatLon(l, 32);
    }

    public static long[] xyFromGeoXPPoint(long l) {
        return HHCodeHelper.splitHHCode(l, 32);
    }

    public static boolean isGeoXPPointInGeoXPShape(long l, GeoXPShape geoXPShape) {
        return Coverage.contains(geoXPShape.geocells, l);
    }

    public static GeoXPShape toGeoXPShape(Geometry geometry, double d, boolean bl, int n) {
        long[] lArray = HHCodeHelper.getBoundingBox(geometry);
        int n2 = HHCodeHelper.getOptimalResolution(lArray, d);
        return GeoXPLib.toGeoXPShape(geometry, n2, bl, n);
    }

    public static GeoXPShape toGeoXPShape(Geometry geometry, int n, boolean bl, int n2) {
        GeoXPShape geoXPShape = new GeoXPShape();
        Coverage coverage = JTSHelper.coverGeometry(geometry, 2, n, bl, n2);
        if (null == coverage) {
            return null;
        }
        coverage.optimize(0L);
        geoXPShape.geocells = coverage.toGeoCells(n);
        return geoXPShape;
    }

    public static GeoXPShape toGeoXPShape(Geometry geometry, double d, boolean bl) {
        return GeoXPLib.toGeoXPShape(geometry, d, bl, Integer.MAX_VALUE);
    }

    public static GeoXPShape toUniformGeoXPShape(Geometry geometry, double d, boolean bl, int n) {
        long[] lArray = HHCodeHelper.getBoundingBox(geometry);
        int n2 = HHCodeHelper.getOptimalResolution(lArray, d);
        return GeoXPLib.toUniformGeoXPShape(geometry, n2, bl, n);
    }

    public static GeoXPShape toUniformGeoXPShape(Geometry geometry, int n, boolean bl, int n2) {
        GeoXPShape geoXPShape = new GeoXPShape();
        Coverage coverage = JTSHelper.coverGeometry(geometry, n, n, bl, n2);
        if (null == coverage) {
            return null;
        }
        geoXPShape.geocells = coverage.toGeoCells(n);
        return geoXPShape;
    }

    public static double[] bbox(GeoXPShape geoXPShape) {
        long[] lArray = new long[2];
        long[] lArray2 = new long[]{Long.MAX_VALUE, Long.MAX_VALUE, Long.MIN_VALUE, Long.MIN_VALUE};
        for (long l : geoXPShape.geocells) {
            long l2;
            int n = (int)(l >>> 60);
            HHCodeHelper.stableSplitHHCode(l << 4, 32, lArray);
            if (lArray[0] < lArray2[0]) {
                lArray2[0] = lArray[0];
            }
            if (lArray[1] < lArray2[1]) {
                lArray2[1] = lArray[1];
            }
            if ((l2 = lArray[0] | LOWER_BITS[n - 1]) > lArray2[2]) {
                lArray2[2] = l2;
            }
            if ((l2 = lArray[1] | LOWER_BITS[n - 1]) <= lArray2[3]) continue;
            lArray2[3] = l2;
        }
        double[] dArray = new double[]{HHCodeHelper.toLat(lArray2[0]), HHCodeHelper.toLon(lArray2[1]), HHCodeHelper.toLat(lArray2[2]), HHCodeHelper.toLon(lArray2[3])};
        return dArray;
    }

    public static GeoXPShape intersection(GeoXPShape geoXPShape, GeoXPShape geoXPShape2) {
        Coverage coverage = new Coverage(geoXPShape.geocells);
        Coverage coverage2 = new Coverage(geoXPShape2.geocells);
        Coverage coverage3 = Coverage.intersection(coverage, coverage2, false);
        coverage3.optimize(0L);
        GeoXPShape geoXPShape3 = new GeoXPShape();
        geoXPShape3.geocells = coverage3.toGeoCells(32);
        return geoXPShape3;
    }

    public static GeoXPShape union(GeoXPShape geoXPShape, GeoXPShape geoXPShape2) {
        Coverage coverage = new Coverage(geoXPShape.geocells);
        Coverage coverage2 = new Coverage(geoXPShape2.geocells);
        coverage.merge(coverage2);
        coverage.dedup();
        coverage.optimize(0L);
        GeoXPShape geoXPShape3 = new GeoXPShape();
        geoXPShape3.geocells = coverage.toGeoCells(32);
        return geoXPShape3;
    }

    public static GeoXPShape subtraction(GeoXPShape geoXPShape, GeoXPShape geoXPShape2) {
        Coverage coverage = new Coverage(geoXPShape.geocells);
        Coverage coverage2 = new Coverage(geoXPShape2.geocells);
        Coverage coverage3 = Coverage.minus(coverage, coverage2, false);
        coverage3.optimize(0L);
        GeoXPShape geoXPShape3 = new GeoXPShape();
        geoXPShape3.geocells = coverage3.toGeoCells(32);
        return geoXPShape3;
    }

    public static double loxodromicDistance(long l, long l2) {
        return HHCodeHelper.loxodromicDistance(l, l2);
    }

    public static double orthodromicDistance(long l, long l2) {
        return HHCodeHelper.orthodromicDistance(l, l2);
    }

    public static byte[] serializeGeoXPShape(GeoXPShape geoXPShape) {
        byte[] byArray = new byte[geoXPShape.geocells.length * 8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        for (int i = 0; i < geoXPShape.geocells.length; ++i) {
            byteBuffer.putLong(geoXPShape.geocells[i]);
        }
        return byArray;
    }

    public static byte[] bytesFromGeoXPPoint(long l, int n) {
        if (n < 2 || n > 32 || 0 != (n & 1)) {
            return null;
        }
        byte[] byArray = new byte[(n >>> 2) + (0 == (n & 2) ? 0 : 1)];
        int n2 = 0;
        for (int i = 0; i < n << 1; i += 4) {
            int n3 = n2++;
            byArray[n3] = (byte)((long)byArray[n3] | l >> 60 - i & 0xFL);
            if (0 != i % 8) continue;
            byArray[n2] = (byte)(byArray[n2] << 4);
        }
        return byArray;
    }

    public static long[] indexable(long l) {
        return HHCodeHelper.toGeoCells(l);
    }

    public static String[] indexableStrings(long l) {
        return HHCodeHelper.toIndexableStrings(l);
    }

    public static String toRegexp(GeoXPShape geoXPShape) {
        return HHCodeHelper.geocellsToRegexp(geoXPShape.geocells);
    }

    public static long[] getCells(GeoXPShape geoXPShape) {
        return geoXPShape.geocells;
    }

    public static GeoXPShape fromCells(long[] lArray, boolean bl) {
        GeoXPShape geoXPShape = new GeoXPShape();
        geoXPShape.geocells = bl ? Arrays.copyOf(lArray, lArray.length) : lArray;
        return geoXPShape;
    }

    public static GeoXPShape fromCells(Collection<Long> collection) {
        long[] lArray = new long[collection.size()];
        int n = 0;
        for (long l : collection) {
            lArray[n++] = l;
        }
        return GeoXPLib.fromCells(lArray, false);
    }

    public static long parentCell(long l) {
        return HHCodeHelper.parentGeoCell(l);
    }

    public static GeoXPShape limit(GeoXPShape geoXPShape, int n) {
        if (geoXPShape.geocells.length <= n) {
            return geoXPShape;
        }
        Coverage coverage = CoverageHelper.fromGeoCells(geoXPShape.geocells);
        coverage.reduce(n);
        GeoXPShape geoXPShape2 = new GeoXPShape();
        geoXPShape2.geocells = coverage.toGeoCells(30);
        return geoXPShape2;
    }

    public static GeoXPShape limitResolution(GeoXPShape geoXPShape, int n) {
        Coverage coverage = CoverageHelper.fromGeoCells(geoXPShape.geocells);
        long l = 0x1111111111111111L;
        coverage.optimize(l, n);
        GeoXPShape geoXPShape2 = new GeoXPShape();
        geoXPShape2.geocells = coverage.toGeoCells(30);
        return geoXPShape2;
    }

    public static GeoXPShape limitResolution(GeoXPShape geoXPShape, int n, int n2) {
        Coverage coverage = CoverageHelper.fromGeoCells(geoXPShape.geocells);
        long l = 0x1111111111111111L;
        coverage.optimize(l, n, n2, 0);
        GeoXPShape geoXPShape2 = new GeoXPShape();
        geoXPShape2.geocells = coverage.toGeoCells(30);
        return geoXPShape2;
    }

    static {
        for (int i = 0; i < 16; ++i) {
            GeoXPLib.LOWER_BITS[i] = 0xFFFFFFFFL >>> (i + 1) * 2;
        }
    }

    public static final class GeoXPShape
    implements Serializable {
        long[] geocells;
    }
}

