/*
 * Decompiled with CFR 0.152.
 */
package com.geoxp.geo;

import com.geoxp.geo.HHCodeHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CentroidGenerator {
    private static int minResolution = 2;
    private static int maxResolution = 30;
    private static long threshold = 0L;
    private static Map<CharSequence, long[]> centroids = new HashMap<CharSequence, long[]>();
    private static Map<CharSequence, List<Long>> markers = new HashMap<CharSequence, List<Long>>();
    private static CharSequence[] currentCells = new CharSequence[15];
    private static StringBuilder sb = new StringBuilder();

    private static void updateCentroids(final long l) {
        sb.setLength(0);
        sb.append(Long.toHexString(l));
        while (sb.length() < 16) {
            sb.insert(0, "0");
        }
        long[] lArray = HHCodeHelper.splitHHCode(l, 32);
        for (int i = minResolution; i <= maxResolution; ++i) {
            long[] lArray2;
            CharSequence charSequence = sb.subSequence(0, i + 1);
            if (centroids.containsKey(charSequence)) {
                lArray2 = centroids.get(charSequence);
                lArray2[1] = lArray2[1] * lArray2[0] + lArray[0];
                lArray2[2] = lArray2[2] * lArray2[0] + lArray[1];
                lArray2[0] = lArray2[0] + 1L;
                lArray2[1] = lArray2[1] / lArray2[0];
                lArray2[2] = lArray2[2] / lArray2[0];
                if (!markers.containsKey(charSequence)) continue;
                markers.get(charSequence).add(l);
                if ((long)markers.get(charSequence).size() <= threshold) continue;
                markers.remove(charSequence);
                continue;
            }
            if (null != currentCells[i]) {
                lArray2 = centroids.get(currentCells[i]);
                if (lArray2[0] > threshold) {
                    System.out.printf("%s %d %x\n", currentCells[i].toString(), lArray2[0], HHCodeHelper.buildHHCode(lArray2[1], lArray2[2], 32));
                } else {
                    System.out.printf("%s %d %x", currentCells[i].toString(), lArray2[0], HHCodeHelper.buildHHCode(lArray2[1], lArray2[2], 32));
                    for (long l2 : markers.get(currentCells[i])) {
                        System.out.printf(" %x", l2);
                    }
                    System.out.println();
                }
                centroids.remove(currentCells[i]);
                markers.remove(currentCells[i]);
            }
            CentroidGenerator.currentCells[i] = charSequence;
            centroids.put(charSequence, new long[]{1L, lArray[0], lArray[1]});
            markers.put(charSequence, (List<Long>)new ArrayList<Long>(){
                {
                    this.add(l);
                }
            });
        }
    }

    private static final void flushCentroids() {
        for (int i = minResolution; i <= maxResolution; ++i) {
            if (null == currentCells[i]) continue;
            long[] lArray = centroids.get(currentCells[i]);
            if (lArray[0] > threshold) {
                System.out.printf("%s %d %x\n", currentCells[i].toString(), lArray[0], HHCodeHelper.buildHHCode(lArray[1], lArray[2], 32));
                continue;
            }
            System.out.printf("%s %d %x", currentCells[i].toString(), lArray[0], HHCodeHelper.buildHHCode(lArray[1], lArray[2], 32));
            for (long l : markers.get(currentCells[i])) {
                System.out.printf(" %x", l);
            }
            System.out.println();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string;
        minResolution = Integer.valueOf(stringArray[0]);
        if (minResolution % 2 != 0 || minResolution < 2 || minResolution > 30) {
            System.out.println("minResolution MUST be even and between 2 and 30");
        }
        if ((maxResolution = Integer.valueOf(stringArray[1]).intValue()) % 2 != 0 || maxResolution < 2 || maxResolution > 30 || maxResolution < minResolution) {
            System.out.println("maxResolution MUST be even and between 2 and 30 and greater or equal to minResolution");
        }
        minResolution >>= 1;
        --minResolution;
        maxResolution >>= 1;
        --maxResolution;
        threshold = Long.valueOf(stringArray[2]);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (null != (string = bufferedReader.readLine())) {
            long l;
            try {
                l = Long.parseLong(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                l = new BigInteger(string, 16).longValue();
            }
            CentroidGenerator.updateCentroids(l);
        }
        CentroidGenerator.flushCentroids();
    }
}

