# -*- coding: utf-8 -*-
import os
import dataiku
import numpy as np
import pandas as pd

# Recipe inputs
vw_scores = dataiku.Folder("YkCaQXwR").get_path()
test = dataiku.Dataset("test").get_dataframe()

# Get data
path = os.path.join(vw_scores, 'predictions.txt')
predictions = np.loadtxt(path)
preds = pd.Series(predictions, name='probability')

all_preds = pd.concat((test, preds), axis=1)

# Recipe outputs
test_scored_vw = dataiku.Dataset("test_scored_vw")
test_scored_vw.write_with_schema(all_preds)
