# -*- coding: utf-8 -*-
import os
import dataiku
import numpy as np
import pandas as pd
import sklearn as sk
from sklearn.externals import joblib

# Recipe inputs
folder_path = dataiku.Folder("PRNy6bsT").get_path()
df = dataiku.Dataset("test").get_dataframe()

#-----------------------------------------------------------------
# Scikit objects
#-----------------------------------------------------------------
schema = joblib.load(os.path.join(folder_path, 'schema.pkl'))
trf_num = joblib.load(os.path.join(folder_path, 'trf_num.pkl'))
trf_cat = joblib.load(os.path.join(folder_path, 'trf_cat.pkl'))
clf = joblib.load(os.path.join(folder_path, 'model.pkl'))

#-----------------------------------------------------------------
# Transform and score
#-----------------------------------------------------------------

# Preprocess numerical features
x_num = trf_num.transform( df[schema['features_num']] )

# Preprocess categorical features
df_cat = df[schema['features_cat']]
features = df_cat.columns

for feature in features:
    if df_cat[feature].dtype != 'object':
        df_cat[feature] = df_cat[feature].astype(str)
data = df_cat.to_dict(orient='records')

x_cat = trf_cat.transform( data )

# Concatenate
X = np.concatenate((x_cat, x_num), axis=1)

# Actually score the new records
scores = clf.predict_proba(X)

#-----------------------------------------------------------------
# Reshape
#-----------------------------------------------------------------
preds = pd.DataFrame(scores, index=df.index).rename(columns={0: 'proba_False', 1: 'proba_True'})
all_preds = df.join(preds)

# Recipe outputs
test_scored_scikit = dataiku.Dataset("test_scored_scikit")
test_scored_scikit.write_with_schema(all_preds)
