In this project, we want to predict how much net profit each new customer is going to bring us in total. In other words, we're **looking to predict our Customer Lifetime Value!** 

To do this, you'll learn how to combine data from several different sources, enrich it, and build and deploy a model on it.

<br/>
**You can explore this sample project in your own Dataiku DSS instance.**  
- From the Dataiku DSS home page, click **+New project > Sample Projects > Use Cases**.
- If your Dataiku DSS server doesn't have Internet access, you can [download this sample](https://update.dataiku.com/dss/5.0/tutorials/DKU_CUSTOMER_LIFETIME_VALUE/dss-tutorial-DKU_CUSTOMER_LIFETIME_VALUE.zip) and import it manually.  Click **+New project > Import project**.


# Business goals
The goal is to build a model to predict how much money a customer will spend, based on his first interactions on our website.
To do this, we'll be using lots of types of data: web traffic data, and historical customer purchases, enriched with open data on countries (GDP).

# How do we do this?

We have collected several different types of data from our historical customers:
- Demographic information (age, gender, location)
- Their actions on our website
- The marketing campaigns they received
- Their previous purchases

In addition, we're going to use data about their location to enrich our dataset.

Using a preparation step, we're going to start by joining the different data sources. Then we'll enrich that data in order to train the model. Then, we can copy the recipe and apply it to new data, so we can score new users using our model!

# Explore the sample project

- Start by taking a look at the flow to see the different steps of data preparation and machine learning that are needed for this project.

<p class="text-center">
<a href="/projects/DKU_CUSTOMER_LIFETIME_VALUE/flow/"  class="btn btn-datasets-color btn-cta-big-mod"><i class="icon-dku-sample_project" class="btn-cta-big-mod-icon" />&nbsp;Flow</a><br/><br/>
</p>

- Take a look at how we clean and analyse historical data, and enrich it with geographic data: 

<p class="text-center">
<a href="/projects/DKU_CUSTOMER_LIFETIME_VALUE/recipes/prepare_crm_prepared/"  class="btn btn-datasets-color btn-cta-big-mod"><i class="icon-dku-sample_project" class="btn-cta-big-mod-icon" />&nbsp;Visual Preparation</a><br/><br/>
</p>

- Check out our random forest algorithm to predict how much revenue will come from each client.

<p class="text-center">
<a href="/projects/DKU_CUSTOMER_LIFETIME_VALUE/savedmodels/8A6fb5O8/versions/"  class="btn btn-datasets-color btn-cta-big-mod"><i class="icon-dku-sample_project" class="btn-cta-big-mod-icon" />&nbsp;Model</a><br/><br/>
</p>

- Finally, check out the output dataset we got after we've deployed the model on our new users. It's published on the dashboard! You can see the column predicting the lifetime value on the right.

<p class="text-center">
<a href="/projects/DKU_CUSTOMER_LIFETIME_VALUE/dashboards/DTp3MvZ_default-dashboard/view/xA3Q68u"  class="btn btn-datasets-color btn-cta-big-mod"><i class="icon-dku-sample_project" class="btn-cta-big-mod-icon" />&nbsp;Dashboard with the Scored Dataset</a><br/><br/>
</p>

<a name="MORE">
#Related content
</a>

If you want more resources (and we know you do), check these out: 

- our [machine learning course](https://academy.dataiku.com/machine-learning-basics) so you can build your first machine learning model in DSS on your own
- the [churn sample project](/projects/DKU_CHURN/), where you'll see not only one but 2 models in one flow
- [our tutorial on deploying a model as a scoring API](https://academy.dataiku.com/real-time-deployment) 
- [End to End Customer Lifetime Value with Real Data](https://knowledge.dataiku.com/latest/solutions/retail/solution-clv-forecast.html)