CREATE OR REPLACE FUNCTION ComputePOI() RETURNS VOID AS
$$
DECLARE
        e RECORD;
        category VARCHAR;
BEGIN
        -- Gather the tables nodes and ways
        CREATE TEMPORARY TABLE nodes_and_ways AS
                (SELECT true AS way, id, tags, linestring as geom FROM "ways_nyc_psql") UNION
                (select false AS way, id, tags, geom from "nodes_nyc_psql");

        DROP TABLE IF EXISTS poi_osm_nyc;
        CREATE TABLE  poi_osm_nyc (
                way boolean,
                osm_id bigint,
                name varchar(1000),
                category varchar(50),
                geom geometry,
                  position geometry
        );

        -- Loop on the table nodes_and_ways to assign the POI into a category
        for e in SELECT * from nodes_and_ways  
        loop
                category := '';
                if e.tags::hstore ? 'shop' THEN
                        if e.tags::hstore -> 'shop' = 'supermarket'
                        then
                                category := 'supermarket';
                        else
                                category := 'shop';
                        end if;
                elsif e.tags::hstore ? 'leisure' OR e.tags::hstore ? 'sport' OR e.tags::hstore ? 'tourism' OR e.tags::hstore ? 'historic' THEN
                        category := 'entertainment';
                elsif e.tags::hstore ? 'railway' then
                        if e.tags::hstore -> 'railway' IN ('station', 'tram_stop') then
                                category := 'transport';
                        end if;
                elsif e.tags::hstore -> 'highway' = 'bus_stop' then
                        category := 'minor_transport';
                elsif e.tags::hstore ? 'amenity' then
                        if e.tags::hstore -> 'amenity' = 'parking' then
                                category := 'parking';
                        elsif e.tags::hstore -> 'amenity' = 'cinema' OR e.tags::hstore -> 'amenity' = 'theatre' then
                                category := 'entertainment';
                        elsif e.tags::hstore -> 'amenity' IN ('pharmacy', 'car_rental', 'fuel', 'car_wash', 'bank', 'atm') then
                                category := 'shop';
                        elsif e.tags::hstore -> 'amenity' IN ('fast_food', 'cafe', 'bar', 'pub', 'restaurant') then
                                category := 'food';
                        elsif e.tags::hstore -> 'amenity' IN ('social_facility', 'hospital', 'police', 'townhall', 'kindergarten', 'library') then
                                category := 'public_service';
                        elsif e.tags::hstore -> 'amenity' IN ('bus_station') then
                                category := 'transport';
                        end if;
                end if;
                if category != '' then
                         insert into poi_osm_nyc VALUES (e.way, e.id, e.tags::hstore -> 'name', category, e.geom, ST_Transform(e.geom, 32018)); -- 32018 is the SRID for NY, you have to choose the right one for your case
                end if;
        end loop;

        -- create a geo index
        CREATE INDEX poi_osm_projected_idx_nyc ON poi_osm_nyc USING GIST (position);
END;
$$
LANGUAGE plpgsql;

SELECT ComputePOI();