SELECT s."id",
       s."geopoint",
       s."geojson",
       SUM(CASE when s.category='shop' then 1 else 0 END) as nb_shop,
       SUM(CASE when s.category='food' then 1 else 0 END) as nb_food,
       SUM(CASE when s.category='minor_transport' then 1 else 0 END) as nb_minor_transport,
       SUM(CASE when s.category='entertainment' then 1 else 0 END) as nb_entertainment,
       SUM(CASE when s.category='supermarket' then 1 else 0 END) as nb_supermarket,
       SUM(CASE when s.category='transport' then 1 else 0 END) as nb_transport,
       SUM(CASE when s.category='parking' then 1 else 0 END) as nb_parking,
       SUM(CASE when s.category='public_service' then 1 else 0 END) as nb_public_service

FROM
( SELECT g."id", g."geopoint", g."geojson", p.category
FROM "nyc_census_geojson" g
LEFT JOIN "poi_osm_nyc" p
ON ST_within(p.position, ST_TRANSFORM(ST_GeomFromText(ST_ASTEXT(multipolygon), 4326),32018))
) s
GROUP BY s."id", s."geopoint", s."geojson"