// Create a Map
var map = L.map('map').setView([40.78, -73.95], 11);

// Add an OpenStreetMap(c) based background
var cartodb =  new  L.tileLayer(
    'http://{s}.basemaps.cartocdn.com/light_all/{z}/{x}/{y}.png', {
    attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors, &copy; <a href="http://cartodb.com/attributions">CartoDB</a>, &copy data provided by <a href="https://foursquare.com/">Foursquare</a>'
})
map.addLayer(cartodb);


// Global vars
var dataDict = {};
var clusterDict = {};
var defName = {};
var colorDict = {"Residential": "#f06548",
                 "Residential with services": "#fdc766",
                 "Cultural & going out places": "#7bc9a6",
                 "Activity center": "#4ec5da",
                 "Randall's Island": "#548ecb",
                 "Shopping areas": "#cf92c5",
                 "Universities": "#5e2974"
                };

function loadCensus(){
    
    dataiku.fetch('heatmap_all_poi_nyc_scored', function(dataFrame) {
        //console.log(dataFrame.getColumnNames());
        //console.log(dataFrame.getRows());

        data = dataFrame.getRows();
        //col = dataFrame.getColumnNames();
        console.log(data[0][2]);

        for (var idx = 0; idx < data.length; idx++) {
            clusterDict[data[idx][0]] = {"nom":data[idx][0], "label": data[idx][23], "polygon": jQuery.parseJSON(data[idx][2])};
        }
        
        drawCensus();
        
    })

};


function drawCensus(){

    d3.select("#map").selectAll("g").remove();
    d3.select("#legendName").selectAll("*").remove();
    d3.select("#legend").selectAll("*").remove();
    //   d3.select("h2").text(valeur); 
    
    for (var key in clusterDict) {
        
        var geojsonFeature = {
            "type": "Feature",
            "properties": {
            "name": "maille"
            }
        };
        
        var style = {
            "value": clusterDict[key],
            "color": colorDict[clusterDict[key]['label']],
            "weight": 5,
            "fillColor" : colorDict[clusterDict[key]['label']],
            "opacity": 0,
            "fillOpacity": 0.5
        };

        geojsonFeature['geometry'] = clusterDict[key]["polygon"];

        var maille = L.geoJson(geojsonFeature, style); 
        var msg = clusterDict[key]['nom'] +' '+ clusterDict[key]['label'] ;
        
        maille.bindPopup(msg)
        maille.addTo(map)
    }
};


function main(){
    loadCensus();
};

main();

