##Replacing cars before they break down

I am data scientist at a large car-rental company. To make sure our clients don't rent out cars that could break down, we replace the cars that we believe are likely to have technical problems regularly. But we don't want to replace them too often either, to limit cost. Part of our business is optimising that balance.

<br/>I recently noticed that 3 months ago more of our cars had technical issues than usual. Last August, an unusual proportion of our cars had a problem with the transmission.

<br/>We had collected data about the cars that where affected by this problem of course, and how these cars had been used in the months before they broke.

<br/>As you can imagine, our goal was to identify the reasons for this problem and find out how to prevent it from happening again in the next months.


<br/>
**You can explore this sample project in your own Dataiku DSS instance.**  
- From the Dataiku DSS home page, click **+New project > Sample Projects > Use Cases**.
- If your Dataiku DSS server doesn't have Internet access, you can [download this sample](https://update.dataiku.com/dss/5.0/tutorials/DKU_PREDICTIVE_MAINTENANCE/dss-tutorial-DKU_PREDICTIVE_MAINTENANCE.zip) and import it manually.  Click **+New project > Import project**.

<br>

# BUSINESS GOALS

1.  Understand why cars are having technical problems at a higher rate
2.  Identify the cars with the highest probability of having the same problem in the future


<br/>
#HOW DID WE DO THIS?

We gathered data to solve those two goals:
   - measures taken during the various failures (august)
   - data about how cars had been used in the weeks before their incidents (june & july)
   - information from the maintenance department (june & july)
<br/>
<br/>We followed 4 steps to go from that raw data to achieving our business goals, and preventing the next failures:

<strong>Step 1: Explore and prepare the data:</strong> We made several transformations to the raw data so we could get valuable information from it. Typically, we transformed that data to create a new dataset aggregated at the car level, with as many relevant features as possible about each vehicle.
<br/>
<br/><strong>Step 2: Create the model:</strong> DSS trained a model to predict the feature we wanted to understand (failure or not failure), using the historical data we computed in the previous step.
<br/>
<br/><strong>Step 3: Apply the model to the new data:</strong> We deployed the model to have the probability that each car would have the same failure in the next few months
<br/>
<br/><strong>Step 4: Make a decision:</strong> Knowing the probability of failure, we identified two groups of cars: the cars we had to check in the 2 next days because they were most likely to have issues, and the cars that we could wait a few extra days to check.


<br/>
#EXPLORE THE SAMPLE PROJECT

1. Look at the flow to retrace the different steps of data preparation (recipe icons in yellow) and machine learning (in green) that were needed to score each car. Check out the different input datasets to get familiar with our raw data.
<p class="text-center">
<a href="/projects/DKU_PREDICTIVE_MAINTENANCE/flow/"  class="btn btn-datasets-color btn-cta-big-mod"><i class="icon-dku-sample_project" class="btn-cta-big-mod-icon" />Flow</a><br/><br/>
</p>

2. See how we build a group recipe to reformat our usage data, to aggregate data at the vehicle level (instead of our original log format):
<p class="text-center">
<a href="/projects/DKU_PREDICTIVE_MAINTENANCE/recipes/group_usage_data/"  class="btn btn-datasets-color btn-cta-big-mod"><i class="icon-dku-sample_project" class="btn-cta-big-mod-icon" />Group recipe</a><br/><br/>
</p>

3. See the different steps of our data preparation script on that usage data, to create new features thanks to the visual editor: 
<p class="text-center">
<a href="/projects/DKU_PREDICTIVE_MAINTENANCE/recipes/compute_usage_data_by_Asset_prepared/"  class="btn btn-datasets-color btn-cta-big-mod"><i class="icon-dku-sample_project" class="btn-cta-big-mod-icon" />Visual analysis</a><br/><br/>
</p>
   
4. See the preparation of our maintenance consumption data, with a good example of how use the pivot function! 
<p class="text-center">
<a href="/projects/DKU_PREDICTIVE_MAINTENANCE/recipes/compute_maintenance_part_consumption_prepared/"  class="btn btn-datasets-color btn-cta-big-mod"><i class="icon-dku-sample_project" class="btn-cta-big-mod-icon" />Visual analysis</a><br/><br/>
</p>
   
5. Now check out how we combine all of our data sources to get all of the information we created in a single dataset, thanks to a join recipe:  
<p class="text-center">
<a href="/projects/DKU_PREDICTIVE_MAINTENANCE/recipes/join_maintenance_failures/"  class="btn btn-datasets-color btn-cta-big-mod"><i class="icon-dku-sample_project" class="btn-cta-big-mod-icon" />Join recipe</a><br/><br/>
</p>
   
6. Machine learning, finally! DSS trained different types of models and compared their performance, so we could deploy our favorite one. All this, in just  few clicks in the visual modelling interface:
<p class="text-center">
<a href="/projects/DKU_PREDICTIVE_MAINTENANCE/analysis/7dowYOoy/ml/p/lOFOPArz/list/results#learning.sessions"  class="btn btn-datasets-color btn-cta-big-mod"><i class="icon-dku-sample_project" class="btn-cta-big-mod-icon" />MODELS</a><br/><br/>
</p>
   
7. After we deployed our model on our new data, which created a new feature with our prediction, we made the result more practical by splitting the resulting dataset in the cars we needed to fix RIGHT NOW and the ones that could wait a little.
<p class="text-center">
<a href="/projects/DKU_PREDICTIVE_MAINTENANCE/recipes/split_Asset_new_informations_scored/"  class="btn btn-datasets-color btn-cta-big-mod"><i class="icon-dku-sample_project" class="btn-cta-big-mod-icon" />Split recipe</a><br/><br/>
</p>

And that's all it took us. No, really though.


#RELATED CONTENT

If you want to look into some other projects or articles related to this sample project, have a go at these:

   - all you need in our (exhaustive) reference documentation: http://doc.dataiku.com/dss/latest/
   - End-to-End Predictive Maintenance with real-world data: Check out the [Predictive Maintenance Dataiku Solution](https://knowledge.dataiku.com/latest/solutions/manufacturing-energy/solution-predictive-maintenance.html)
 
 
In general, you'll find lots of stuff in the Learn section: http://www.dataiku.com/learn/  
And if don't find what you need, ask about it in the Q&A: http://answers.dataiku.com/