import dataiku
import pandas as pd
from datetime import datetime
from dataiku.scenario import Scenario

# The Scenario object is the main handle from which you initiate steps

scenario = Scenario()

# Get the variables, and update the date

client = dataiku.api_client()
project_name = dataiku.get_custom_variables()["projectKey"]
project = client.get_project(project_name)
variables = project.get_variables()

variables["standard"]["today_year"] = datetime.now().year
variables["standard"]["today_month"] = datetime.now().month
variables["standard"]["today_day"] = datetime.now().day
project.set_variables(variables)

# Rebuild the two visual recipes
# By default, recursive build
# The other options are "NON_RECURSIVE_FORCED_BUILD", "RECURSIVE_FORCED_BUILD", "RECURSIVE_MISSING_ONLY_BUILD".
scenario.build_dataset("birthdates_filtered")

# Access to dataset

df = dataiku.Dataset("birthdates_filtered").get_dataframe()
lendf = len(df)


# Build a message

if lendf == 0:
    mess = "Hello! No birthday today."

elif lendf == 1:
    mess = "Hello! Today is " + df["name"].loc[0] + "'s birthday (" + str(df["age"].loc[0]) + " y.o)."

else:
    mess = "Hello! We celebrate the birthdays of "
    for i in range(lendf-1):
        mess += df["name"].loc[i] + " (" + str(df["age"].loc[i]) + " y.o), "
    mess = mess[:-2] + " and " + df["name"].loc[lendf-1] + " (" + str(df["age"].loc[lendf-1]) + " y.o). "
    
# Output message in a variable

variables = project.get_variables()
variables["standard"]["message"] = mess
project.set_variables(variables)