# Configurations
The [Dataiku Admin](project:DKUADMIN) provides pre-configured Jupyter notebooks to automatically set configuration values to Dataiku recommended values

## Remove Root Filesystem

This sequence of steps removes the default `Root Filestem Connection` as it can present a security risk by exposing the OS filesytem to DSS users.

### Steps
1. Navigate to [1 - Configs - Delete Filesystem Root Connection](jupyter_notebook:1 - Configs - Delete Filesystem Root Connection)
2. Run the 1st code block to get a list of current DSS connections
3. Code block #2 contains the code to remove the `Root Filesystem Connection` commented out.
![Remove_Root_Filesystem_Commented.png](MMYEGofQZwef)
4. Uncomment the following two statements
![Remove_Root_Filesystem_Uncommented.png](ZpbIndcbe4vH)
5. Run the 2nd Code Block to remove the Root Filesystem Connection
6. Verify removal
  -  Either, re-run the 1st code block in the notebook; or
  - Navigate to Settings -> Administration -> Connections and ensure the `filesystem_root` connection has been removed.

## Metastore

This sequence of steps sets the default DSS Metastore to the internal DSS_INTERNAL metastore.

### Steps
1. Navigate to [1 - Configs - Metastore](jupyter_notebook:1 - Configs - Metastore)
2. Run all the steps in the notebook
3. Verify the Metstore is set correctly
  - Navigate to Settings -> Administration -> Compute & Scaling (Metastore Catalogs)
  - Verify the Metastore Kind has been set to `Internal DSS Catalog (for Spark-on-K8S)`
  
  ![Metastore_Catalog_Verification.png](A6RKwbIMxtNE)

## Spark and Container Exec

This sequence of steps will create mulitple Container Exec and Spark Configurations in accordance with Dataiku's best practices.

### Steps
1. Navigate to [1 - Configs - Spark and Container Exec](jupyter_notebook:1 - Configs - Spark and Container Exec)
2. Set the cloud provider variable to the appropriate value
![Cloud_Provider.png](DUFR8bab5dVD)
3. Set appropriate Cloud Provider Values e.g. `Account ID` and `Region`
  - *NOTE*: values will depend upon the specific Cloud Provider i.e. (Azure, AWS, or GCP)
![Cloud_Provider_Values.png](xVfFzNpZuUat)
4. Run all Code Blocks in the Notebook
5. Verify Container Exec and Sparks Configs created successfully
  - Container Exec
      1. Navigate to Settings -> Administration -> Compute & Scaling (Containerized execution)
      2. Verify `eks|aks|gke-default` configuration exists
      3. Verify `eks|aks|gke-Webapp` configuration exists
  - Spark
      1. Navigate to Settings -> Administration -> Compute & Scaling (Spark)
      2. Verify `Spark-Standard` configuration exists
      3. Verify `Spark-Large` configuration exists
      4. Verify `Spark-HiMem` configuration exists