# Purpose of the Dataiku Admin Project
The DSS Admin project is a collection of DSS flow steps, notebooks, and DSS scenarios with the purpose of  configuring DSS instances in-line with Dataikus's configuration and administration best practices.  The project provides a step by step process to assist customers and Dataiku Field Engineers with delivering well configured DSS instances. 

The tools in the project create configurations with reasonable defaults, installs and configures maintenance jobs for optimal performance, and provides the means for automated testing of various DSS functionality.

# Benefits

The DSS Admin project provides a quick and easy way to setup, configure, and verify that DSS instances are configured to Dataiku's best practices.  The flow, notebooks, and scenarios that are included ensures that the platform is well configured and that sensible defaults are set.


# Notes

In order to realize the full benefit of the Dataiku Admin project, DSS will needs to be configured for use with [Elastic AI](https://doc.dataiku.com/dss/latest/containers/index.html).  Parts of the project may still be useful such as the [Removal of the Root Filesystem](https://fe-demo-dev-design.fe-aws.dkucloud-dev.com/projects/DKUADMIN/wiki/4/Usage#remove-root-filesystem-1) but most will not.

# Usage
The various steps included in the DSS Admin Project are mostly self-contained, but we recommend you follow the order specified below.  The [Functional Tests](#functional-tests-1) do have a dependency on [Configurations](#configurations-1). These configuration and functional tests are contained in:
 - The project flow 
 - Notebooks 
 - Webapps
 - API Designer

# Order of Operation
The various sections should be run in the following order:
  1. [Configurations](article:8)
  2. [Functional Tests](article:9)
  3. [Scenarios](article:10)