import base64
from PIL import Image
import io

def encode_image(folder, image_path):
    """
    Encode an image in base 64.
    """
    with folder.get_download_stream(image_path) as stream:
        return base64.b64encode(stream.read()).decode('utf-8')
    
    
def load_image(folder, filepath):
    """
    Load an image from a folder.
    """
    with folder.get_download_stream(filepath) as stream:
        return Image.open(io.BytesIO(stream.read()))
      