Using the application involves collaboration between domain experts (e.g., Procurement Manager, Investment Analyst), data experts, and data stewards. The matching and data enrichment process should remain efficient and accurate so that Sustainability teams can consume its output over time.  

Here's a streamlined guide to initial use and handling updates.

# Initial Use  

- **Domain Expert: Prepare Acronyms**
  - Refine the list of business structure acronyms (e.g., "Inc", "NV") to improve name preprocessing.
- **Data Expert: Configure and Run Automated Matching**
  - Set thresholds for fuzzy matching and automatic validation.
  - Run the pipeline to produce datasets for perfect, uncertain, and missing matches.
  - Review initial results: number of uncertain matches to validate and number of matches to find manually. This can be facilitated by a simple chart, to add to a "Matching Management" dashboard.  
      ![Automated Matching chart showing that a large number of companies (689 out of 2001) don't have a match](EDnTVeS7jauu)
  - Adjust thresholds and rerun if needed.
- **Domain Expert: Validate Matches**
  - Use the “Validate Uncertain Matches” webapp to confirm or adjust automated suggestions.
  - Use the “Find Missing Matches” webapp to manually resolve unmatched entities.
  - Use the “Comments” column to communicate ideas with data experts on improving the automated matching pipeline. For example, when matching “Saudi British Bank” with “The Saudi British Bank”, a comment can be left to suggest removing “The” when it’s at the start of a company name. Data experts can then take this feedback into account and rerun automated matching, which would reduce the amount of remaining manual work for domain experts.  
  - Make sure to also review the tips shared in the [Dashboard's Help page](https://design.solutions.dataiku-dss.io/projects/ENTITY_RESOLUTION/dashboards/JDVodKt_Match%20CRM%20against%20PROVIDER/view/u4rtEHJ).
- **Data Steward: Publish Results**
  - Monitor progress through additional charts in the Matching Management dashboard.  
    ![Human Feedback charts showing that half of the validation work is done, and that the manual matching work was barely started.](b3jhWkU6twsK)
  - Trigger a rebuild of the enriched datasets from the matching table and a refresh of the downstream reports. In Dataiku this can be facilitated with an automation "Scenario", which could be triggered from a dashboard by adding a Run Scenario button. A “Reporter” could be configured to automatically send notifications (and the refreshed reports) to Sustainability Analysts upon successful Scenario execution.

# Lifecycle Management: Handling Updates

- **Data Steward:**
  - Monitor updates to the CRM and the external provider's data. Compare the latest datasets with previous versions to identify changes (e.g., new entities, modified names).
  - Rerun the automated matching pipeline to capture new or updated matches. This can be done autonomously (i.e., without help from the data expert who set up the Dataiku project) with the project’s “Update Source” Scenario and a Run Scenario button at the beginning of the Matching Management dashboard.
- **Domain Experts:** Validate newly suggested or modified matches through the web interfaces.
- **Data Steward:** Trigger the pipeline to rebuild the matching table and enriched datasets, refresh reporting dashboards, and notify Sustainability Analysts.

# Example: Responding to Dataset Changes

Imagine your external provider updates its dataset with new company entries or new names for existing entries. Re-running the pipeline could result in:

- **Reduced Validation Load:** Certain entities may now be confidently matched, reducing manual validation needs.
- **New Automatic Matches:** Some previously unmatched entities may now be found in the “Validate Uncertain Matches” webapp. Note that if the automated match of a given entity changed, but a previous match had already been validated, the latter will hold: there is nothing to validate a second time.
- **New Manual Matching Opportunities:** There may now be matches for entities whose matches were previously set to NONE (i.e. unmatchable entities). Domain experts should thus review all such entities in both webapps.