# 3 March 2025: v1.7

**Please note that the code environments (`py_310_sample_llm` and `py39_huggingface`) needs to be updated for this new version**. Cf. its [specifications](article:2).

- [2. Basic use - code](flow_zone:default) Flow zone:
  - A new [Python recipe](recipe:compute_pvFOY2UN) illustrates image generation through the Dataiku Python API;
  - A new [Python recipe](recipe:compute_extracted_json_structured_output) shows how to get structured outputs through the Dataiku Python API;
- [3. Retrieval-based question answering - visual](flow_zone:nS8CTF4) Flow zone:
  - A [multimodal RAG](recipe:compute_documents_multimodal_embedded) pipeline is now illustrated in this Flow zone. It is based on the Embed Documents recipe introduced in Dataiku 13.4;
  - The ad hoc Python recipe for LLM evaluation has been replaced with visual LLM Evaluation recipes ([one](recipe:evaluate_answers) for the text-only RAG pipeline and [one](recipe:evaluate_answers_multimodal) for the multimodal RAG pipeline);
- [4. Retrieval-based question answering - code](flow_zone:wwVg0ys) Flow zone:
  - A [code agent](saved_model:bR8FHxfn) mimicking the ad hoc Python recipe has been added in the Flow. The corresponding [web app](web_app:gfMP9Yq) now uses this code agent;
  - The ad hoc Python recipe for LLM evaluation has been replaced with visual LLM Evaluation recipes ([one](recipe:evaluate_answers2) for the Python recipe and [one](recipe:evaluate_answers_code_prepared) for the code agent);
- [5. LLM-powered agents](flow_zone:Gzn9KXV) Flow zone:
  - A [code agent](saved_model:2k5v5N3O) mimicking the ad hoc Python recipe has been added in the Flow. The corresponding [web app](web_app:e5X6LOZ) now uses this code agent;
  - The [web app](web_app:hXM9IXb) showing a conversational agent and illustrating how we can sollicit the approval of the user when the agent requests the use of a sensitive tool is now implemented though a [code agent](saved_model:NH0cSHSy);
- [6. Text-to-SQL](flow_zone:N8de5Jm) Flow zone:
  - A [code agent](saved_model:MSIGB581) mimicking the ad hoc Python recipe has been added in the Flow. The corresponding [web app](web_app:x9jctZd) now uses this code agent;
- [7. LLM fine-tuning](flow_zone:LZpUc7e) Flow zone:
  - The models fine-tuned with a Python recipe are now stored as [saved models](https://developer.dataiku.com/latest/concepts-and-examples/llm-mesh.html#create-a-fine-tuned-llm-saved-model-version) ([one](saved_model:VOqI4fIf) for supervised fine-tuning and [one](saved_model:Yt3MdkME) for preference optimization);
  - Supervised fine-tuning is now also achieved with a [visual recipe](recipe:finetune_finetuned_for_information_extraction);
- Web apps:
  - A [Traces Explorer webapp](web_app:EIKF2DY) has been added;
  - Several web apps are now using code agents and have then been significantly streamlined.

# 11 September 2024: v1.6

**Please note that the `py_310_sample_llm` code environment needs to be updated for this new version**. Cf. its [specifications](article:2).

- [2. Basic use - code](flow_zone:default) Flow zone:
  - The [code recipe](recipe:compute_sentiment_llm_mesh) showing the use of the Dataiku API for LLM completion now illustrates the use of the `logit_bias` parameter;
  - A new [code recipe](recipe:compute_image_descriptions) shows how to use a multimodal LLM;
- [3. Retrieval-based question answering - visual](flow_zone:nS8CTF4) Flow zone:
  - The [Prepare recipe](recipe:compute_documents_extracted_prepared) is now in charge of splitting the documents into chunks. This allows to further process these chunks, for example to incorporate metadata;
- [5. LLM-powered agents](flow_zone:Gzn9KXV) Flow zone:
  - The agent example using agent-related features of `langchain` has been [rewritten](recipe:compute_requests_processed_langgraph) to use `langgraph`. `langgraph` is a new library in the LangChain ecosystem and it is the option recommended by LangChain maintainers to implement agents;
  - The [web app](web_app:hXM9IXb) showing a conversational agent is now based on `langgraph` and illustrates how we can sollicit the approval of the user when the agent requests the use of a sensitive tool.
  - The [three](web_app:e5X6LOZ) [other](web_app:1yaSXSp) [web apps](web_app:x9jctZd) with LLM-powered agents now also use `langgraph`;
- [6. Text-to-SQL](flow_zone:N8de5Jm) Flow zone:
  - New Flow zone and [web app](web_app:x9jctZd) showing how an LLM can generate SQL queries for a database;
- [7. Reliability and safety](flow_zone:PexGVbv) Flow zone:
  - The [code recipe](recipe:compute_extracted_json_openai_function_call) demonstrating the use of function calling now does so through the Dataiku API for LLM completion;
- [8. LLM fine-tuning](flow_zone:LZpUc7e) Flow zone:
  - The [LLM-as-a-judge evaluation](recipe:compute_po_predictions_evaluated) now leverages function calling through the Dataiku API for LLM completion.

## Other changes
- Wherever it was used, `gpt-3.5-turbo` was replaced with `gpt-4o`.

# 12 April 2024: v1.5

**Please note that the `py_310_sample_llm` code environment needs to be updated for this new version**. Cf. its [specifications](article:2).

## Agents
  - New [code recipe](recipe:compute_requests_processed_chat_model) implementing an agent with a chat model;
  - New [web app](web_app:GSkVIyJ) with a chat interface for an agent;
  - New [code recipe](recipe:compute_agent_answers_evaluated) to evaluate the answers and the trajectories of an agent with three different methods.

## General cleanup
  - Removal of the examples with the OpenAI GPT Completion plugin (now that this plugin is deprecated and that the LLM Mesh is generally available);
  - Removal of some code recipes of the [2. Basic use - code](flow_zone:default) Flow zone that are redundant with the [code recipe](recipe:compute_sentiment_llm_mesh) using the LLM Mesh, now that it is generally available;
  - Update of the two [code](recipe:compute_sentiment) [recipes](recipe:compute_sentiment_probabilities) calling the OpenAI API to take into account the breaking changes introduced in `v1`of the `openai` Python packages, as well as the fact that the `logit_bias` and `top_logprobs` parameters of the OpenAI API cannot be used jointly since March 2024;
  - Update of the code recipes and webapps using `langchain`, in particular to use the [LangChain Expression Language (LCEL)](https://python.langchain.com/docs/expression_language/) and to replace the LangChain`ChatOpenAI` (`OpenAI`) LLM by a Dataiku `DKUChatLLM` (or `DKULLM`) LLM whenever possible;
  - Use of the `ml.evaluate` module instead of `ragas` to evaluate LLM outputs.

# 16 January 2024: v1.4

## Changes related to the deprecation of `text-davinci-003` by OpenAI:
- [2. Basic use - code](flow_zone:default):
  -  `text-davinci-003` replaced with `gpt-3.5-turbo-instruct` in the [recipe](recipe:compute_sentiment_guidance) with the `guidance` example and equivalent recipe with `LMQL` removed (because the `LMQL` feature used in this recipe does not work with `gpt-...` models);
- [3. Retrieval-based question answering - visual (≥ 12.3)](flow_zone:nS8CTF4): 
  - `LMQL` replaced by `guidance` in the [evaluation Python recipe](recipe:compute_answers_evaluated_2);
- [4. Retrieval-based question answering - code](flow_zone:wwVg0ys):
  - `LMQL` replaced by `guidance` in the [evaluation Python recipe](recipe:compute_answers_evaluated);
- [6. Reliability and safety](flow_zone:PexGVbv)
  - `text-davinci-003` replaced with `gpt-3.5-turbo-instruct` in the [recipe](recipe:compute_extracted_json_lmql) with the `LMQL` example. **This requires an upgrade of LMQL (v0.7.3 in the `py_310_sample_llm` code environment** ;

## Other changes:
- [3. Retrieval-based question answering - visual (≥ 12.3)](flow_zone:nS8CTF4): 
  - [Prepare recipe](recipe:compute_documents_extracted_prepared) simplified thanks to the improvements of the latest version (v2.3) of the [Text Extraction and OCR plugin](https://www.dataiku.com/product/plugins/tesseract-ocr/).  **This requires an upgrade of the Text Extraction and OCR plugin (v2.3)** ;
  - New [web app](web_app:MNIEqRT) to illustrate how to query a [knowledge bank](retrievable_knowledge:iXhIIXV5) to retrieve semantic search results. It requires **Dataiku v12.4.1**.

# 19 December 2023: v1.3

- [2. Basic use - code](flow_zone:default):
  - Example with Dolly v2 replaced by an [example with Mistral-7B](recipe:compute_sentiment_mistral);
  - [Python recipe](recipe:compute_sentiment) demonstrating the use of the Chat Completion OpenAI API updated: classification scores are now provided with the [results](dataset:sentiment_openai_chat) thanks to the new `logprobs` parameter;
- [3. Retrieval-based question answering - visual (≥ 12.3)](flow_zone:nS8CTF4)
  - [Text extraction recipe](recipe:compute_documents_extracted) updated with version 2.2.0 of the Text Extraction and OCR plugin to split documents in a way that better take into accounts their structure (for example, by using sections and sub-sections with the HTML document);
  - New [Prepare recipe](recipe:compute_documents_extracted_prepared) to clean the text and the metadata before splitting, vectorizing and indexing them;
- [7. LLM fine-tuning](flow_zone:LZpUc7e)
  - New flow zone demonstrating how to fine-tune an open source model ([supervised fine-tuning](recipe:compute_74GhsK3Z) and [preference optimization](recipe:compute_HUY9JaOD));
- Various changes to improve the documentation, streamline or correct the code...

# 26 October 2023: v1.2
- [1. Basic use - visual (≥ v12.3)](flow_zone:JSx6cEw):
  - New examples of visual NLP recipes for [text classification](recipe:compute_classification2) and [summarization](recipe:compute_product_reviews_summarized);
  - New examples of visual Prompt recipes for [translation](recipe:compute_product_reviews_translated) and [structured extraction](recipe:compute_product_reviews_extracted) (associated prompt studio: [extraction](prompt_studio:fINIYbf));
- [2. Basic use - code](flow_zone:default):
  - New [Python recipe](recipe:compute_sentiment_llm_mesh) to show how to programmatically use an LLM connection;
- [3. Retrieval-based question answering - visual (≥ 12.3)](flow_zone:nS8CTF4): 
  - New retrieval-based question answering pipeline including an [Embed recipe](recipe:compute_knowledge_bank) and a visual [Prompt recipe](recipe:compute_answers2) (associated prompt studio: [question_answering](prompt_studio:IoyBOUn));
  - New [Python recipe](recipe:compute_answers_evaluated2) adding new evaluation metrics provided by the RAGAS package, on top on the two evaluation metrics introduced in the latest version. Additionally, the evaluation results are now also stored in an [evaluation store](model_evaluation_store:pNMEtc4y) (v12.2 and above);
  - New minimalistic [web app](web_app:qpPlJBw) to get answers based on the [input documents](managed_folder:TyR7HVoz), just with a LLM connection, without LangChain;
- [4. Retrieval-based question answering - code](flow_zone:wwVg0ys):
  - New [Python recipe](recipe:compute_answers_evaluated) adding new evaluation metrics provided by the RAGAS package, on top on the two evaluation metrics introduced in the latest version. Additionally, the evaluation results are now also stored in an [evaluation store](model_evaluation_store:jNuKpcAc) (v12.2 and above);
  - Experiment tracking added to the question-answering [Python recipe](recipe:compute_answers_evaluated);
  - Possibility to use an LLM connection through the Dataiku API added to the question-answering [Python recipe](recipe:compute_answers_evaluated) and the corresponding [web app](web_app:gfMP9Yq);
  - New [web app](web_app:1yaSXSp) showing a conversational interface to answer questions based on the [input documents](managed_folder:TyR7HVoz) (in complement to the existing [webapp](web_app:gfMP9Yq) that can be used for one-shot questions, without follow-up);
- [5. LLMs combined with tools](flow_zone:Gzn9KXV): 
  - Both Python recipes updated to add experiment tracking;
- Possibility to use an LLM connection through the Dataiku API added to the Chatbot [web app](web_app:3hKu5FA);
- `text-davinci-003`OpenAI model replaced by the new `gpt-3.5-turbo-instruct`OpenAI model in the [compute_sentiment_probabilities](recipe:compute_sentiment_probabilities) Python recipe. `gpt-3.5-turbo-instruct` is much cheaper and `text-davinci-003` will soon be deprecated;
- Various changes to improve the documentation, streamline or correct the code...

# 11 August 2023: v1.1
- [2. Basic use (with code)](flow_zone:default):
  - New Python recipes illustrating other proprietary LLM APIs ([Cohere](recipe:compute_sentiment_cohere), [AI21](recipe:compute_sentiment_ai21), [Anthropic](recipe:compute_sentiment_anthropic))
- [3. Retrieval-based question answering](flow_zone:Ioicxik):
  - New [Python recipe](recipe:compute_answers_evaluated) showing two approaches to automatically compare generated answers with reference answers
- [4. LLMs combined with tools](flow_zone:Gzn9KXV)
  - New [Python recipe](recipe:compute_requests_processed_openai_function_call) demonstrating the use of the new "[function calling](https://openai.com/blog/function-calling-and-other-api-updates)" OpenAI feature for agents
- [5. Reliability and safety](flow_zone:PexGVbv)
  - New [Python recipe](recipe:compute_extracted_json_lmql) to force compliance with a given JSON schema (thanks to [LMQL](https://lmql.ai/))
  - New [Python recipe](recipe:compute_extracted_json_openai_function_call) to improve compliance with a given JSON schema (thanks to the new "[function calling](https://openai.com/blog/function-calling-and-other-api-updates)" OpenAI feature)
- Webapps:
  - New [web app](web_app:3hKu5FA) implementing a chatbot (chat user interface + memory)
- Various changes to improve the documentation, streamline or correct the code...

# 7 June 2023: initial release