import pandas as pd
from typing import List

def normalize(cont_cols: List[str],
              data: pd.DataFrame) -> pd.DataFrame:
    for c in cont_cols:
        avg = data[c].mean()
        std = data[c].std()
        data[c] = (data[c]-avg) / (1e-7 + std)
    return data


def uci_bank():
    data = {
        "cat_cols": ["job", "marital", "education", "default", "housing", 
                     "loan", "month"],
        "cont_cols": ["age", "balance", "day", "duration", "campaign"],
        "target": ["y"],
        "df_train": pd.read_csv("../data/uci-bank-marketing/training_data.csv",
                                sep=','),
        "df_eval": pd.read_csv("../data/uci-bank-marketing/eval_data.csv",
                                sep=',')                           
    }

    return data


