# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
# -*- coding: utf-8 -*-
import dataiku
import json
from project_utils import (
    load_image,
    save_image,
    process_annotations,
    add_boxes,
    get_color_map,
)

df = dataiku.Dataset("test_scored_custom").get_dataframe()
images_folder = dataiku.Folder("PRCGY0s7")
output_folder = dataiku.Folder("tnwIk1ma")

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
cat2id, counter = {}, 0
for i in range(len(df)):
    df.iloc[i].prediction = json.loads(df.iloc[i].prediction)
    for annotation in df.iloc[i].prediction:
        if annotation["category"] not in cat2id:
            cat2id[annotation["category"]] = counter
            counter += 1

color_map = get_color_map(cat2id)

# -------------------------------------------------------------------------------- NOTEBOOK-CELL: CODE
for i in range(len(df)):
    img = load_image(images_folder, df.iloc[i]["record_id"])
    size = max([x // 500 for x in img.shape[:2]])
    annotations = df.iloc[i]["prediction"]

    rectangles, text_boxes = process_annotations(annotations, color_map, size=size)

    add_boxes(img, rectangles, text_boxes)

    # Write images in the output folder
    save_image(output_folder, df.iloc[i]["record_id"], img)
