# Overview
This example project illustrates how you can implement an **object detection** use case with Dataiku. More precisely we show the following steps:
1. **Train a visual model** for a labeled object detection dataset;
2. **Compute predictions** for new images;
3. **Evaluate** the accuracy of the predictions;
4. **Visualize** the predictions;
5. **Label unlabeled new images** with Dataiku's Managed Labeling feature;
6. **Train a code-based custom model**.

# Data
We use the [Microcontroller Object Detection dataset](https://www.kaggle.com/datasets/tannergi/microcontroller-detection), which includes 149 images with **4 models of microcontrollers** ("8266 ESP", "Arduino Nano", "Heltec ESP32 Lora", "Raspberry Pi 3"). Our goal is to **identify whether and where these objects are present in the images**.
![raspberry.png](JgZ0yd9IvP2C)

# Walkthrough
## Prepare the train set and the test set

The initial data are located in the [1. Input Data](flow_zone:FceqPRw) Flow zone. A [folder](managed_folder:PRCGY0s7) contains all the images and a [dataset](dataset:annotations) lists, for each image, the category and location of the objects in this image. We use a [Split recipe](recipe:split_annotations) to create a **train set** and a **test set**.

## Train the visual model

In the [2. Visual Model](flow_zone:OpjpY1w) Flow zone, we create a first **object detection model using Dataiku's [visual features](https://doc.dataiku.com/dss/latest/machine-learning/computer-vision/index.html)**(i.e. without code). For this, we create an [Object Detection visual analysis](analysis:5bFZ8lqj), which allows to visualize examples of images in the dataset and define the training procedure (hyperparameters, augmentation methods, evaluation metric...). For now, we keep the default values.

Once the model is trained, we can visualize its performance and test it on images through the visual interface. We can also deploy the [model](saved_model:DAtNPkhb) in the Flow so that predictions for the [test set](dataset:test) can be computed through a [Scoring recipe](recipe:score_test).

## Visualize and evaluate the predictions of the visual model

The predictions of an object detection model are harder to understand and interpret than those of a classification model. For this reason, we include in the [3. Visualization and Evaluation](flow_zone:u7okzMi) Flow zone two recipes to evaluate and visualize these predictions.

To **evaluate the predictive performance of the model**, we use the [Average Precision metrics](https://cocodataset.org/#detection-eval) corresponding to 3 *Intersection over Union (IoU)* configurations (50%, 75% and average over 50%-95%). These metrics are available in the visual interface for the validation set used during training. We compute these metrics for our test set with a [Python recipe](recipe:compute_evaluation). In particular, the *Average Precision (IoU = 50%)* or *AP50* is equal to 0.87, which is quite good given the small number of images. The *Average Precision (IoU = 75%)* or *AP75* is less satisfying with a value of 0.39. This suggests that the model's predictions are broadly correct for the categories but insufficiently accurate for the bounding boxes.

When it comes to **visualizing the predictions for specific image**, a [Python recipe](recipe:compute_v48Dbhba) creates a version of the test images with the predicted bounding boxes. You can visualize these images in a [folder](managed_folder:v48Dbhba). You can also look at both the true and predicted bounding boxes with a [Dash web app](web_app:pGA2Xkh). Visualizing the images is important to understand the strenghts and weaknesses of the model but also to detect incorrect labels in the original dataset. We can for example see that one ground truth bounding box for "8266 ESP" is missing in the 27th image of the test set.

![webapp.png](6D2i8HCa2Okt)

## Label new images

The [4. Labeling](flow_zone:default) Flow zone illustrates how to **label new images**. The details (path, name, format...) of these new images are first extracted with a [List Contents recipe](recipe:compute_images_to_label_files). Based on these details and the new images' [folder](managed_folder:uMh1FtqB), we can set up a new [labeling task](labeling_task:AtQ5Hp0YHf) (potential classes, instructions, number of labelers per image...). Once the annotations for the images have been provided and reviewed, they are available in a [dataset](dataset:labeled) than can be used for training.

![labeling.png](ZgVdroyVGjKd)

## Bonus: train a custom model

The native features of Dataiku already allow us to conveniently adapt the training procedure to the specificities of our use case. If more flexibility is needed, it is easy to use external libraries with Python recipes. We illustrate this in the [5. Bonus: Custom model](flow_zone:WKvvDhV) Flow zone. More specifically, we use [Detectron2](https://github.com/facebookresearch/detectron2), "Facebook AI Research's next generation library that provides state-of-the-art detection and segmentation algorithms". We transpose [Detectron2's tutorial notebook](https://detectron2.readthedocs.io/en/latest/tutorials/getting_started.html) in a [Python training recipe](recipe:compute_vRa5vtTP) and a [Python scoring recipe](recipe:compute_test_set_scored_custom). We can then use the same recipes as before to [evaluate](recipe:compute_evaluation_1) and [visualize](recipe:compute_v48Dbhba_1) the predictions.

The visual model and the custom model can be compared quantitatively and qualitatively through a [dashboard](dashboard:13EVsfx) showing the metrics and the predictions for the test set. The custom model seems to perform better than the visual model. Having said that, the test set is very small and both models were trained with default hyperparameters without efforts to optimize their predictive performance.

<table>
<thead>
  <tr>
    <th style="border: 0px"></th>
    <th colspan="3">Average Precision</th>
  </tr>
</thead>
<tbody>
  <tr>
    <td style="border: 0px"></td>
    <td><b>IoU = 0.5</b><br></td>
    <td><b>IoU = 0.75</b><br></td>
    <td><b>All IoUs</b><br></td>
  </tr>
  <tr>
    <td><b>Visual model</b></td>
    <td>0.87</td>
    <td>0.39</td>
    <td>0.43</td>
  </tr>
  <tr>
    <td><b>Custom model</b></td>
    <td>0.95</td>
    <td>0.95</td>
    <td>0.73</td>
  </tr>
</tbody>
</table>

# Next: Train your own object detection models
## Technical requirements
This project:
- leverages features available starting from **Dataiku 11**;
- requires to create two dedicated **code environments**:
  - a code environment named `INTERNAL_object_detection_v1` which is the [built-in code environment](https://doc.dataiku.com/dss/latest/machine-learning/computer-vision/first-model.html#install-the-required-packages) for the object detection visual feature in Dataiku
  - a Python 3.8 code environment named `py_38_sample_object_detection` with the following packages: 
``` 
torch==1.8.1
torchvision==0.9.1
pyyaml==5.1
opencv-python==4.6.0.66
dash==2.6.1
dash-bootstrap-components==1.2.1
git+https://github.com/facebookresearch/detectron2.git
```

Using a [GPU](https://doc.dataiku.com/dss/latest/machine-learning/computer-vision/runtime-gpu.html) saves a lot of time, especially for large datasets but it is not strictly required.

## How to reuse this project
The project can be downloaded [here](https://downloads.dataiku.com/public/dss-samples/EX_OBJECT_DETECTION/).

Once you have imported the project, you can directly navigate the Flow.

If you want to use your own data, put your images in this [folder](managed_folder:PRCGY0s7) and replace this [dataset](dataset:annotations) with the corresponding annotations. **Make sure that the annotations are in the right format** or use a Prepare recipe or a Python recipe to convert them. You may also include unlabeled images in this [folder](managed_folder:uMh1FtqB) and reset the [labeling task](labeling_task:AtQ5Hp0YHf).

The [Dash web app](web_app:pGA2Xkh) can be used with any dataset containing annotations. For this, you just need to change the reference to the dataset at the beginning of the web app's code.

All the datasets are stored in filesystem so no remapping will be needed. However you have the option to [change the connection type](https://knowledge.dataiku.com/latest/courses/flow-views-and-actions/connection-changes-concept-summary.html#connection-changes) if you want to rely on a specific data storage type. 

If you want to leverage certain parts of the Flow directly, keep in mind that Dataiku allows you to reuse elements at different levels. In particular it is possible to:
- [duplicate a whole project](https://knowledge.dataiku.com/latest/kb/governance/How-to-duplicate-a-DSS-project.html)
- [copy and paste entire subflows](https://knowledge.dataiku.com/latest/courses/flow-views-and-actions/connection-changes-concept-summary.html#copy-subflow)
- [copy and paste recipes](https://knowledge.dataiku.com/latest/kb/collaboration/How-to-copy-a-recipe-in-your-Flow.html) and remap input/output datasets
- [copy and paste preparation steps](https://doc.dataiku.com/dss/latest/preparation/copy-steps.html) within a Prepare recipe  

# Related Resources
- [Computer Vision Dataiku official Documentation](https://doc.dataiku.com/dss/latest/machine-learning/computer-vision/index.html)
- [Crash Course in Dataiku 11](https://academy.dataiku.com/crash-course-dataiku-11) (covering Managed Labeling and Visual Deep Learning) on the Dataiku Academy