# ONNX Exporter[¶](https://www.dataiku.com/product/plugins/onnx-exporter/)

## The ONNX exporter plugin allows to export Visual Deep Learning and Keras .h5 models to ONNX format.[¶](https://www.dataiku.com/product/plugins/onnx-exporter/)

## Plugin information[¶](https://www.dataiku.com/product/plugins/onnx-exporter/)

|  |  |

| --- | --- |

| Version | 1.1.0 |

| Author | Dataiku (Arnaud d’Esquerre, Nicolas Dalsass) |

| Released | 2020-07-15 |

| Last updated | 2022-06-09 |

| License | Apache 2.0 |

| Source code | Github |

| Reporting issues | Github |

## What is ONNX?[¶](https://www.dataiku.com/product/plugins/onnx-exporter/)

ONNX is an open format built to represent machine learning models for scoring (inference) purposes. ONNX defines a common set of operators – the building blocks of machine learning and deep learning models – and a common file format to enable AI developers to use models with a variety of frameworks, tools, runtimes, and compilers. More info here

## Description[¶](https://www.dataiku.com/product/plugins/onnx-exporter/)

This plugin aims at offering an easy way to deploy deep learning models to various systems with the ONNX runtime.    You can learn more about the languages, architectures and hardware accelerations supported by ONNX runtime here.

It offers the conversion of two kinds of models:

* Visual Deep Learning models trained with DSS

* Keras `.h5 models`.

Note that for Visual Deep Learning models, the plugin will export the model itself but not the features handling defined in DSS.

This plugin contains one recipe and one macro for each conversion type.

Visual Deep Learning models trained with DSS:

* Convert saved model to ONNX macro

* Convert saved model to ONNX recipe

Keras `.h5 models`:

* Convert Keras .h5 model to ONNX macro

* Convert Keras .h5 model to ONNX recipe

## Installation Notes[¶](https://www.dataiku.com/product/plugins/onnx-exporter/)

The plugin can be installed from the Plugin Store or via the zip download (see installation panel on the right).

## How to use the Macros ?[¶](https://www.dataiku.com/product/plugins/onnx-exporter/)

### Convert saved model to ONNX macro[¶](https://www.dataiku.com/product/plugins/onnx-exporter/)

#### Available parameters[¶](https://www.dataiku.com/product/plugins/onnx-exporter/)

* `Saved model` (DSS saved model): Visual Deep Learning model trained in DSS to convert

* `Output folder` (DSS managed folder): Folder where the ONNX model will be added

* `Output model path` (String): Path where the ONNX model will be stored

* `Overwrite if exists` (boolean): Whether the model should overwrite the existing file at same path (if it already exists)

* `Fixed batch size` (boolean): Some runtimes do not support dynamic batch size and thereefore the size should be specified during export.

* `Batch size` (int) [optional]: Batch size of the model’s input

* `Force input/output to Float (32 bits)` (boolean): Some runtimes do not support `Double`. Uncheck if your runtime supports `Double`

### Convert Keras .h5 model to ONNX macro[¶](https://www.dataiku.com/product/plugins/onnx-exporter/)

#### Available parameters[¶](https://www.dataiku.com/product/plugins/onnx-exporter/)

* `Input folder` (DSS managed folder): Folder where the .h5 model is

* `Model path`(String): Path to the .h5 model to convert

* `Output folder` (DSS managed folder) [optional]: Folder where the ONNX model will be added.

If `Output folder` is left empty the model is added to the input folder.

* `Output model path` (String): Path where the ONNX model will be stored

* `Overwrite if exists` (boolean): Whether the model should overwrite the existing file at same path (if it already exists)

* `Fixed batch size` (boolean): Some runtimes do not support dynamic batch size and thereefore the size should be specified during export.

* `Batch size` (int) [optional]: Batch size of the model’s input

* `Force input/output to Float (32 bits)` (boolean): Some runtimes do not support `Double`. Uncheck if your runtime supports `Double`

The macros are also available in the `Macro` menu of a project.

## How to use the Recipes ?[¶](https://www.dataiku.com/product/plugins/onnx-exporter/)

### Convert saved model to ONNX recipe[¶](https://www.dataiku.com/product/plugins/onnx-exporter/)

#### Available parameters[¶](https://www.dataiku.com/product/plugins/onnx-exporter/)

* `Output model path` (String): Path where the ONNX model will be stored

* `Overwrite if exists` (boolean): Whether the model should overwrite the existing file at same path (if it already exists)

* `Fixed batch size` (boolean): Some runtimes do not support dynamic batch size and thereefore the size should be specified during export.

* `Batch size` (int) [optional]: Batch size of the model’s input

* `Force input/output to Float (32 bits)` (boolean): Some runtimes do not support `Double`. Uncheck if your runtime supports `Double`

### Convert Keras .h5 model to onnx recipe[¶](https://www.dataiku.com/product/plugins/onnx-exporter/)

#### Available parameters[¶](https://www.dataiku.com/product/plugins/onnx-exporter/)

* `Model path`(String): Path to the .h5 model to convert

* `Output folder` (DSS managed folder) [optional]: Folder where the ONNX model will be added.

If `Output folder` is left empty the model is added to the input folder.

* `Output model path` (String): Path where the ONNX model will be stored

* `Overwrite if exists` (boolean): Whether the model should overwrite the existing file at same path (if it already exists)

* `Fixed batch size` (boolean): Some runtimes do not support dynamic batch size and thereefore the size should be specified during export.

* `Batch size` (int) [optional]: Batch size of the model’s input

* `Force input/output to Float (32 bits)` (boolean): Some runtimes do not support `Double`. Uncheck if your runtime supports `Double`

##### Install in DSS[¶](https://www.dataiku.com/product/plugins/onnx-exporter/)

To install the plugin, open the  Apps menu, click Plugins and search for ONNX exporter.

Alternatively, you can download a zipped version here.

### Get the Dataiku Data Sheet[¶](https://www.dataiku.com/product/plugins/onnx-exporter/)

Learn everything you ever wanted to know about Dataiku (but were afraid to ask), including detailed specifications on features and integrations.
