# OpenWeatherMap[¶](https://www.dataiku.com/product/plugins/open-weather-map/)

## This plugin provides a read connector to import historical & forecast weather data from OpenWeatherMap[¶](https://www.dataiku.com/product/plugins/open-weather-map/)

## Plugin information[¶](https://www.dataiku.com/product/plugins/open-weather-map/)

|  |  |

| --- | --- |

| Version | 1.0.1 |

| Author | Dataiku (Henri Chabert) |

| Released | 2020-06-01 |

| Last updated | 2020-06-01 |

| License | Apache Software License |

| Source code | Github |

| Reporting issues | Github |

## How to set up[¶](https://www.dataiku.com/product/plugins/open-weather-map/)

### General set up[¶](https://www.dataiku.com/product/plugins/open-weather-map/)

* OpenWeatherMap API key: The API key you just copied

* System of units: The default system of units you want to use (It can be overwritten when running the recipe)

* Language: Language of the text describing the weather (It can be overwritten when running the recipe).

### Cache set up[¶](https://www.dataiku.com/product/plugins/open-weather-map/)

The OpenWeatherMap plugin uses a cache system to store data locally, in order to avoid repeating identical queries. You can change preferences by following the following steps:

* Cache size (in MegaBytes): The maximum size of the cache file (Default is 1Go)

* Cache eviction policy: The way you want the data to be deleted once the maximum size is reached. You have the choice between three modes:

+ Least Recently Stored: Delete the oldest cache records first

+ Least recently Used: Deleted cache records that weren’t used for the longest time

+ Least Frequently Used: Deleted cache records that are the least frequently used

+ No eviction: Overwrite cache size, the cache will grow without bounds

## How to use[¶](https://www.dataiku.com/product/plugins/open-weather-map/)

The plugin is made of two main components:

* A **connector** that allows you to retrieve the data directly from OpenWeatherMap API and put it in a new dataset.

* A **recipe** that allows you to add weather information to your data containing lat/lon and data column

### OpenWeatherMap connector[¶](https://www.dataiku.com/product/plugins/open-weather-map/)

* Daily information are available 5 days in the past and 7 days in the future. The output dataset is 12 rows long

* Hourly information are available 5 days in the past and 2 days in the future. The output dataset is 168 rows long

#### Advanced mode[¶](https://www.dataiku.com/product/plugins/open-weather-map/)

You can configure more settings by checking “Advanced mode”. The available options are:

* Data type: You can choose whether you wish to have historical data, forecast data or both (Default is both)

* System of units: It overwrites the settings of the preset for this specific job

* Language: It overwrites the settings of the preset for this specific job

* Use cache: It overwrites the settings of the preset for this specific job

* Parse output JSON: If you prefer to get a unique column containing the entire response in JSON format, you can check this

### OpenWeatherMap recipe[¶](https://www.dataiku.com/product/plugins/open-weather-map/)

In addition of the weather data, a column named “error” will be added to the output dataset. If something went wrong when retrieving the data for the specific pair location/date, this column will tell you what it is. The errors usually come from the fact that the date is not in the available range [today – 5 days ; today + 7 days] or that you reached your API calls limit.

#### Advanced mode[¶](https://www.dataiku.com/product/plugins/open-weather-map/)

You can configure more settings by checking “Advanced mode”. The available options are:

* System of units: It overwrites the settings of the preset for this specific job

* Language: It overwrites the settings of the preset for this specific job

* Use cache: It overwrites the settings of the preset for this specific job

* Parse output JSON: If you prefer to get a unique column containing the entire response in JSON format, you can check this. **You should check this option if you use the option “Append instead of overwrite”**

##### Install In DSS[¶](https://www.dataiku.com/product/plugins/open-weather-map/)

To install the plugin, open the  Apps menu, click Plugins and search for OpenWeatherMap.

Alternatively, you can download a zipped version here.

### Get the Dataiku Data Sheet[¶](https://www.dataiku.com/product/plugins/open-weather-map/)

Learn everything you ever wanted to know about Dataiku (but were afraid to ask), including detailed specifications on features and integrations.
