# Confluence Exporter[¶](https://www.dataiku.com/product/plugins/confluence/)

## This plugin provides a export connector to push your Dataiku DSS projects wiki in Confluence.[¶](https://www.dataiku.com/product/plugins/confluence/)

## Plugin information[¶](https://www.dataiku.com/product/plugins/confluence/)

|  |  |

| --- | --- |

| Version | 1.0.0 |

| Author | Dataiku (Alex Bourret) |

| Released | 2019-03-16 |

| Last updated | 2019-03-16 |

| License | Apache Software License |

| Source code | Github |

| Reporting issues | Github |

## How to set up[¶](https://www.dataiku.com/product/plugins/confluence/)

* One installed, the login credentials to the Confluence service need to be set up. As a DSS administrator, go to **Plugins > Installed > Confluence wiki > Settings > Confluence login** and add a preset. There, fill in the connection details and make the preset available to the relevant DSS user / group.

* For online Confluence instances, you will need to first create an API token. To do so, go to your **Profile > Manage your account > Security > Create and manage API tokens > Create API token**. Copy the created token and paste it into the API token box of your DSS preset.

* A space needs to exist on the Confluence server. On Confluence, use the **Spaces > Create Space** menu, choose a space name and copy the space key. Then paste it in the **Confluence Space key** box of your DSS preset.

* The DSS URL needs to be filled in. Go to **Administration > Settings > Notifications & Integrations > DSS Location** and make sure that the DSS URL is set up.

## How to use[¶](https://www.dataiku.com/product/plugins/confluence/)

Once the plugin is set up, navigate to the DSS project containing the wiki pages to push to Confluence. Once in the project, click on **Macro > Wiki Confluence export**. Select the preset corresponding to the Confluence Space you are targeting, and press **Run Macro**.

## Known Issues[¶](https://www.dataiku.com/product/plugins/confluence/)

* All code must be inside a code block. Any html tag present outside a code block is likely to make the page’s transfer fail.

* Compliance to HTML and Markdown standards is more stringent on Confluence than on DSS Wiki. Some HTML code might result in a functional wiki page on DSS but may be refused on Confluence. If that’s the case, an error message will appear in place of the wiki page. It’s up to you to go back to the DSS wiki page and fix the issue there before attempting another transfer.

* For the same reasons, discrepancies between the DSS Wiki and the uploaded Confluence version can appear when blocks are not properly separated by a line.

* URLs are directly clickable in the DSS wiki, but are not with Confluence, unless they where properly tagged in markdown using the [title](url) scheme.

### Install In DSS[¶](https://www.dataiku.com/product/plugins/confluence/)

To install the plugin, open the  Apps menu, click Plugins and search for Confluence Exporter.

Alternatively, you can download a zipped version here.

### Get the Dataiku Data Sheet[¶](https://www.dataiku.com/product/plugins/confluence/)

Learn everything you ever wanted to know about Dataiku (but were afraid to ask), including detailed specifications on features and integrations.
