# Julia[¶](https://www.dataiku.com/product/plugins/julia/)

## This plugin adds support for the Julia programming language in DSS[¶](https://www.dataiku.com/product/plugins/julia/)

## Plugin information[¶](https://www.dataiku.com/product/plugins/julia/)

|  |  |

| --- | --- |

| Version | 1.0.0 |

| Author | Dataiku (Célian Haydont) |

| Released | 2020-06-15 |

| Last updated | 2020-06-15 |

| License | Apache Software License |

| Source code | Github |

| Reporting issues | Github |

## Installation[¶](https://www.dataiku.com/product/plugins/julia/)

This plugin requires DSS >= 8.0. The Julia language must be installed on the machine.

After installing the plugin, an administrator has to run the Julia installation script `$DSS_HOME/bin/dssadmin install-julia-integration`. The script will take a few minutes to create the code environment, download the required libraries, precompile them and create a Jupyter kernel.

## How to use[¶](https://www.dataiku.com/product/plugins/julia/)

After the installation, it will be possible to create and execute Julia recipes the same way you would use any other code recipes. A Julia kernel also becomes available for Jupyter notebooks.

Inside recipes and notebooks, use the package Dataiku.jl to interact with DSS. This package is a wrapper around the DSS Public API and provides functions to read and write datasets and folders in DSS easily. See the documentation on the package’s README.md

## Code environments[¶](https://www.dataiku.com/product/plugins/julia/)

For now, it is **not** possible to have multiple code environments in Julia. Therefore, all the julia recipes and notebooks will use the same environment that is located at `$DSS_HOME/code-envs/julia`. To install or remove packages, this environment has to be managed manually using the julia’s built-in package manager, there are 2 ways to do that:

* By using Pkg inside a Jupyter notebook in DSS

* By running `julia` with the environment variable `JULIA_DEPOT_PATH=$DSS_HOME/code-envs/julia`

### Install In DSS[¶](https://www.dataiku.com/product/plugins/julia/)

To install the plugin, open the  Apps menu, click Plugins and search for Julia, Julia, ocean child.

Alternatively, you can download a zipped version here.

### Get the Dataiku Data Sheet[¶](https://www.dataiku.com/product/plugins/julia/)

Learn everything you ever wanted to know about Dataiku (but were afraid to ask), including detailed specifications on features and integrations.
