# SharePoint Online[¶](https://www.dataiku.com/product/plugins/sharepoint-online/)

## This plugin provides a read/write connector to interact with SharePoint Online documents and lists[¶](https://www.dataiku.com/product/plugins/sharepoint-online/)

## Plugin information[¶](https://www.dataiku.com/product/plugins/sharepoint-online/)

|  |  |

| --- | --- |

| Version | 1.0.13 |

| Author | Dataiku (Alex Bourret) |

| Released | 2020-03-16 |

| Last updated | 2022-11-10 |

| License | Apache Software License |

| Source code | Github |

| Reporting issues | Github |

## How to set up[¶](https://www.dataiku.com/product/plugins/sharepoint-online/)

### Note[¶](https://www.dataiku.com/product/plugins/sharepoint-online/)

This plugin is intended to be used with SharePoint Online only. For the other SharePoint Server editions (2013, 2016, 2019), please refer to the unsupported plugin which can be found here.

### Option 1: using your SharePoint login[¶](https://www.dataiku.com/product/plugins/sharepoint-online/)

#### Limitations[¶](https://www.dataiku.com/product/plugins/sharepoint-online/)

This authentication method cannot be used if your account is set up with MFA or if it belongs to a federated space name.

You can find out whether or not this is the case by going to this URL (after editing it with your SharePoint account email address):  `https://login.microsoftonline.com/[email protected]`. The key `NameSpaceType` should read `Managed`. If it is `Federated`, you will need to use “Site App Token” instead.

#### Set up[¶](https://www.dataiku.com/product/plugins/sharepoint-online/)

Find your SharePoint tenant and site name from the URL

Say a typical URL for the files you want to give access to is `https://dataiku.sharepoint.com/sites/rnd/plugins/Shared%20Documents/safe/list.xlsx`

* **Tenant** is the sub domain prior to sharepoint.com, here `dataiku`

* **Site path** is the path to the SharePoint site or sub-site you want to give access to. In this example it would be `sites/rnd/plugins`

* **Root directory** is the path to the highest level directory you want your DSS users to have access to. In the current example, `Shared Documents/safe` will let the user browse any files and folders in the sub-directory `safe`. Default value for **Root directory** is `Shared Documents`, but it can also be left blank, in which case the user can access all the document libraries of the `rnd/plugins` site.

### Option 2 : using Azure Single Sign On[¶](https://www.dataiku.com/product/plugins/sharepoint-online/)

Create a new App in Azure Portal

Add a client secret to the app

Add permissions to the app

Add a plugin preset

Trigger the credential request

### Option 3 : using Site App token[¶](https://www.dataiku.com/product/plugins/sharepoint-online/)

An application token can be created to give DSS an access to a given SharePoint site path. Note that only a tenant administrator of the SharePoint site can create this token.

* Register an app with your SharePoint site by going to site’s URL followed by `/_layouts/15/appregnew.aspx`. The whole URL should look like this: `https://{your tenant name}.sharepoint.com/{your site path}/_layouts/15/appregnew.aspx`. Pick a name, generate the client ID and secret and copy them. Set `localhost` as App Domain, and `https://localhost` as redirect URL.

* Next you will have to give the token the proper access rights. Go to your site’s URL followed by `_layouts/15/appinv.aspx`. The URL should look like this: `https://{your tenant name}.sharepoint.com/{your site path}/_layouts/15/appinv.aspx`.

* Enter the client ID created at the first step and press **Lookup**

* In the **Permission Request XML** box, copy and past this: `<AppPermissionRequests AllowAppOnlyPolicy="true"><AppPermissionRequest Scope="http://sharepoint/content/tenant" Right="FullControl" /></AppPermissionRequests>`. More details about rights can be found on SharePoint’s documentation.

* Finally, press **Create** and **OK**

* Find your tenant ID. To do this, click on **Cog > Site settings > Site collection app permissions**. There you should see the App you created in the first step. The App Identifier contains two alphanumerical strings separated by a `@` symbol. The string left of the @ is your app ID. The string right of the @ is your tenant ID. Copy it.

* In DSS, go to **App > Plugins > Installed > SharePoint Online > SharePoint Online Site App Permissions**. Create a new preset, and paste the tenant name, client secret, client ID and tenant ID. This preset will now be useable by using **Site App Permissions** as type of authentication.

## How to use[¶](https://www.dataiku.com/product/plugins/sharepoint-online/)

* In your DSS project flow, select **Dataset > SharePoint**

* Click **Shared Documents** or **Lists**, according to the data source you are trying to sync DSS to.

* Pick the authentication type and the preset, and browse to the document or folder you want to use as dataset.

Browse to the dataset path

* For Azure Single Sign On presets, the DSS users can access other SharePoint sites they have access rights to. For this, select **Show advanced parameters** and set the site path and/or root path in **Site path preset overwrite** / **Root directory preset overwrite**

* If the source is a list,

+ you will have know its name beforehand.

+ although all the column names will be visible, only these selected in the SharePoint’s list standard view will be populated with data.

If necessary, another list view can be selected:

Find the Sharepoint view name

Select the SharePoint list view in DSS

### Export data back to SharePoint Online[¶](https://www.dataiku.com/product/plugins/sharepoint-online/)

#### As a document[¶](https://www.dataiku.com/product/plugins/sharepoint-online/)

The last directory in the path should be used by your DSS project only

#### As a list[¶](https://www.dataiku.com/product/plugins/sharepoint-online/)

**Limitations**: DSS datasets can also be exported to SharePoint Online as lists. However, this operation will overwrite any existing list bearing the same name. Also, some types (such as lookup or calculated fields) do not exist in DSS and would therefore be replaced by strings. For these reasons, it is strongly recommended to export lists from DSS to SharePoint only on specific lists created with the intent of being updated by DSS. Keep in mind that any user modification on the SharePoint side will be overwritten at the next sync.

##### Install In DSS[¶](https://www.dataiku.com/product/plugins/sharepoint-online/)

To install the plugin, open the  Apps menu, click Plugins and search for SharePoint Online.

Alternatively, you can download a zipped version here.

### Get the Dataiku Data Sheet[¶](https://www.dataiku.com/product/plugins/sharepoint-online/)

Learn everything you ever wanted to know about Dataiku (but were afraid to ask), including detailed specifications on features and integrations.
