# Text Summarization[¶](https://www.dataiku.com/product/plugins/text-summarization/)

## This plugin provides a recipe to automatically summarize text data[¶](https://www.dataiku.com/product/plugins/text-summarization/)

## Plugin Information[¶](https://www.dataiku.com/product/plugins/text-summarization/)

|  |  |

| --- | --- |

| Version | 1.3.0 |

| Author | Dataiku (Hicham EL BOUKKOURI, Amanda MILBERG, Niklas MUENNIGHOFF) |

| Released | 2018-09 |

| Last updated | 2022-05 |

| License | Apache Software License |

| Source code | Github |

| Reporting issues | Github |

This plugin provides a tool for doing automatic text summarization.    It uses extractive summarization methods, which means that the summary will be a number of extracted sentences from the original input text. This can be used for example to turn customer reviews or long reports into shorter texts.

The plugin comes with a single recipe that uses one of three possible models:

* **Text Rank**`[1]`, which builds a graph of every sentence of the input text, where each text is linked to its most similar sentences, before running the PageRank algorithm to select the most relevant sentences for a summary.

* **KL-Sum**`[2]`, which summarizes texts by decreasing a KL Divergence criterion. In practice, it selects sentences based on how much they have the same word distribution as the original text.

* **LSA**`[3]`, which uses Latent Semantic Allocation (LSA) to summarize texts. Basically, this starts by looking for the most important topics of the input text then keeps the sentences that best represent these topics.

## How To Use[¶](https://www.dataiku.com/product/plugins/text-summarization/)

First, make sure your text data is stored in a dataset, inside a text column, with one row for each document.  Using the recipe is straightforward: select your dataset and the column containing your documents. Then, select a method, set the number of desired sentences and run the recipe!

## References[¶](https://www.dataiku.com/product/plugins/text-summarization/)

Rada Mihalcea and Paul Tarau, *TextRank: Bringing Order into Texts*.

Aria Haghighi and Lucy Vanderwende, *Exploring Content Models for Multi-Document Summarization*.

Josef Steinberger and Karel Ježek, *Using Latent Semantic Analysis in Text Summarization and Summary Evaluation*.

### Install In DSS[¶](https://www.dataiku.com/product/plugins/text-summarization/)

To install the plugin, open the  Apps menu, click Plugins and search for Text Summarization.

Alternatively, you can download a zipped version here.

### Get the Dataiku Data Sheet[¶](https://www.dataiku.com/product/plugins/text-summarization/)

Learn everything you ever wanted to know about Dataiku (but were afraid to ask), including detailed specifications on features and integrations.
