# Users and groups[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#users-and-groups "Permalink to this heading")

The API exposes key parts of the DSS access control management: users and groups. All these can be created, modified and deleted through the API.

## Example use cases[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#example-use-cases "Permalink to this heading")

In all examples, `client` is a `dataikuapi.dssclient.DSSClient`, obtained either using `dataikuapi.dssclient.DSSClient.\_\_init\_\_()` or `dataiku.api\_client()`

### Listing users[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#listing-users "Permalink to this heading")

§ client = DSSClient(host, apiKey)

§ dss\_users = client.list\_users()

§ # dss\_users is a list of dict. Each item represents one user

§ prettyprinter.pprint(dss\_users)

outputs:

§ [   {   'activeWebSocketSesssions': 0,

§ 'codeAllowed': True,

§ 'displayName': 'Administrator',

§ 'groups': ['administrators', 'data\_scientists'],

§ 'login': 'admin',

§ 'objectImgHash': 0,

§ 'sourceType': 'LOCAL'},

§ ...

§ ]

### Listing connected users[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#listing-connected-users "Permalink to this heading")

You can programmatically retrieve the list of connected users on a Dataiku instance, for example to check if you can safely turn off/restart the instance. This is possible by using the `list\_users()` method of the Dataiku public API. That method returns a value for `activeWebSocketSessions`which indicates the number of sessions that a user is logged into at the moment. Anything other than 0 indicates that a user is connected to the instance.

§ import dataiku

§ client = dataiku.api\_client()

§ user\_list = []

§ dss\_users = client.list\_users()

§ for user in dss\_users:

§ if user["activeWebSocketSessions"]!=0:

§ user\_list.append(user["displayName"])

§ print(user\_list)

### Creating a user[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#creating-a-user "Permalink to this heading")

#### A local user with a password[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#a-local-user-with-a-password "Permalink to this heading")

§ new\_user = client.create\_user('test\_login', 'test\_password', display\_name='a test user', groups=['all\_powerful\_group'])

new\_user is a `dataikuapi.dss.admin.DSSUser`

#### A user who will login through LDAP[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#a-user-who-will-login-through-ldap "Permalink to this heading")

Note that it is not usually required to manually create users who will login through LDAP as they can be automatically provisionned

§ new\_user = client.create\_user('test\_login', password=None, display\_name='a test user', source\_type="LDAP", groups=['all\_powerful\_group'], profile="DESIGNER")

#### A user who will login through SSO[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#a-user-who-will-login-through-sso "Permalink to this heading")

This is only for non-LDAP users that thus will not be automatically provisioned, buut should still be able to log in through SSO.

§ new\_user = client.create\_user('test\_login', password=None, display\_name='a test user', source\_type="LOCAL\_NO\_AUTH", groups=['all\_powerful\_group'], profile="DESIGNER")

### Modifying a user’s display name, groups, profile, email, …[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#modifying-a-users-display-name-groups-profile-email "Permalink to this heading")

To modify the settings of a user, get a handle through `dataikuapi.dssclient.DSSClient.get\_user()`, then use `dataikuapi.dss.admin.DSSUser.get\_settings()`

§ user = client.get\_user("theuserslogin")

§ settings = user.get\_settings()

§ # Modify the settings in the `get\_raw()` dict

§ settings.get\_raw()["displayName"] = "DSS Lover"

§ settings.get\_raw()["email"] = "my.new.email@stuff.com"

§ settings.get\_raw()["userProfile"] = "DESIGNER"

§ settings.get\_raw()["groups"] = ["group1", "group2", "group3"] # This completely overrides previous groups

§ # Save the modifications

§ settings.save()

### Deleting a user[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#deleting-a-user "Permalink to this heading")

§ user = client.get\_user('test\_login')

§ user.delete()

### Modifying user and admin properties[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#modifying-user-and-admin-properties "Permalink to this heading")

§ user = client.get\_user("test\_login")

§ settings = user.get\_settings()

§ settings.user\_properties["myprop"] = "myvalue"

§ settings\_admin\_properties["myadminprop"] = "myadminvalue"

§ settings.save()

### Modifying user secrets[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#modifying-user-secrets "Permalink to this heading")

§ user = client.get\_user("test\_login")

§ settings = user.get\_settings()

§ settings.add\_secret("secretname", "secretvalue")

§ settings.save()

### Entering a per-user-credential for a connection[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#entering-a-per-user-credential-for-a-connection "Permalink to this heading")

§ user = client.get\_user('test\_login')

§ settings = user.get\_settings()

§ settings.set\_basic\_connection\_credential("myconnection", "username", "password")

§ settings.save()

### Entering a per-user-credential for a plugin preset[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#entering-a-per-user-credential-for-a-plugin-preset "Permalink to this heading")

§ user = client.get\_user('test\_login')

§ settings = user.get\_settings()

§ settings.set\_basic\_plugin\_credential("myplugin", "my\_paramset\_id", "mypreset\_id", "param\_name", "username", "password")

§ settings.save()

### Impersonating another user[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#impersonating-another-user "Permalink to this heading")

As a DSS administrator, it can be useful to be able to perform API calls on behalf of another user.

§ user = client.get\_user("the\_user\_to\_impersonate")

§ client\_as\_user = user.get\_client\_as()

§ # All calls done using `client\_as\_user` will appear as being performed by `the\_user\_to\_impersonate` and will inherit

§ # its permissions

### Modifying user secrets[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#id1 "Permalink to this heading")

§ user = client.get\_user("an\_user")

§ settings = user.get\_settings()

§ settings.add\_secret("secretname", "secretvalue")

§ settings.save()

### Listing groups[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#listing-groups "Permalink to this heading")

A list of the groups can by obtained with the `list\_groups()` method:

§ client = DSSClient(host, apiKey)

§ # dss\_groups is a list of dict. Each group contains at least a "name" attribute

§ dss\_groups = client.list\_groups()

§ prettyprinter.pprint(dss\_groups)

outputs

§ [   {   'admin': True,

§ 'description': 'DSS administrators',

§ 'name': 'administrators',

§ 'sourceType': 'LOCAL'},

§ {   'admin': False,

§ 'description': 'Read-write access to projects',

§ 'name': 'data\_scientists',

§ 'sourceType': 'LOCAL'},

§ {   'admin': False,

§ 'description': 'Read-only access to projects',

§ 'name': 'readers',

§ 'sourceType': 'LOCAL'}]

### Creating a group[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#creating-a-group "Permalink to this heading")

§ new\_group = client.create\_group('test\_group', description='test group', source\_type='LOCAL')

### Modifying settings of a group[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#modifying-settings-of-a-group "Permalink to this heading")

First, retrieve the group definition with a `get\_definition()` call, alter the definition, and set it back into DSS:

§ group\_definition = new\_group.get\_definition()

§ group\_definition['admin'] = True

§ group\_definition['ldapGroupNames'] = 'group1,group2'

§ new\_group.set\_definition(group\_definition)

### Deleting a group[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#deleting-a-group "Permalink to this heading")

§ group = client.get\_group('test\_group')

§ group.delete()

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/users-groups.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dss.admin.DSSUser`(client, login) | A handle for a user on the DSS instance. |

| `dataikuapi.dss.admin.DSSUserSettings`(client, ...) | Settings for a DSS user. |

| `dataikuapi.dss.admin.DSSOwnUser`(client) | A handle to interact with your own user Do not create this object directly, use `dataikuapi.DSSClient.get\_own\_user()` instead. |

| `dataikuapi.dss.admin.DSSOwnUserSettings`(...) | Settings for the current DSS user. |

| `dataikuapi.dss.admin.DSSUserActivity`(client, ...) | Activity for a DSS user. |

| `dataikuapi.dss.admin.DSSGroup`(client, name) | A group on the DSS instance. |
