# Workspaces[¶](https://developer.dataiku.com/latest/concepts-and-examples/workspaces.html#workspaces "Permalink to this heading")

You can interact with the Workspaces through the API.

## Basic operations[¶](https://developer.dataiku.com/latest/concepts-and-examples/workspaces.html#basic-operations "Permalink to this heading")

### Listing workspaces[¶](https://developer.dataiku.com/latest/concepts-and-examples/workspaces.html#listing-workspaces "Permalink to this heading")

§ workspaces = client.list\_workspaces(True)

§ # Returns a list of DSSWorkspace

§ for workspace in workspaces:

§ # Access to main information in the workspace

§ print("Workspace key: %s" % workspace.workspace\_key)

§ print("Display name: %s" % workspace.get\_settings().display\_name)

§ print("Description: %s" % workspace.get\_settings().description)

§ print("Permissions: %s" % workspace.get\_settings().permissions) # Returns a list of DSSWorkspacePermissionItem

§ # You can also list the objects in a workspaces

§ print("Objects: %s" % workspace.list\_objects())

### Modifying workspace[¶](https://developer.dataiku.com/latest/concepts-and-examples/workspaces.html#modifying-workspace "Permalink to this heading")

§ workspace = client.get\_workspace("WORKSPACE\_KEY")

§ settings = workspace.get\_settings()

§ settings.permissions = [\*settings.permissions, DSSWorkspacePermissionItem.member\_user("LOGIN"), DSSWorkspacePermissionItem.contributor\_group("GROUP")]

§ settings.save()

### Deleting a workspace[¶](https://developer.dataiku.com/latest/concepts-and-examples/workspaces.html#deleting-a-workspace "Permalink to this heading")

§ workspace = client.get\_workspace("WORKSPACE\_KEY")

§ workspace.delete()

## Adding and deleting the objects in a workspace[¶](https://developer.dataiku.com/latest/concepts-and-examples/workspaces.html#adding-and-deleting-the-objects-in-a-workspace "Permalink to this heading")

§ workspace = client.get\_workspace("WORKSPACE\_KEY")

§ workspace\_objects = workspace.list\_objects()

§ for workspace\_object in workspace\_objects

§ workspace\_object.delete()

§ workspace.add\_object(client.get\_project("PROJECT\_KEY").get\_dataset("DATASET\_NAME")) # To add a dataset

§ workspace.add\_object(client.get\_project("PROJECT\_KEY").get\_wiki("WIKI").get\_article("ARTICLE"))  # To add an article

§ workspace.add\_object(client.get\_app("APP\_ID")) # To add an app

§ workspace.add\_object({"htmlLink": {"name": "Dataiku", "url": "https://www.dataiku.com/", "description": "Dataiku website"}}) # You can also specify the content as a dict, here we add a link

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/workspaces.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dss.workspace.DSSWorkspace`(...) | A handle to interact with a workspace on the DSS instance. |

| `dataikuapi.dss.workspace.DSSWorkspaceObject`(...) | A handle on an object of a workspace |

| `dataikuapi.dss.workspace.DSSWorkspaceSettings`(...) | A handle on the settings of a workspace |

| `dataikuapi.dss.workspace.DSSWorkspacePermissionItem`(data) |  |
