# Connections[¶](https://developer.dataiku.com/latest/concepts-and-examples/connections.html#connections "Permalink to this heading")

The API exposes DSS connections, which can be created, modified and deleted through the API. These operations are restricted to API keys with the “admin rights” flag.

A list of the connections can by obtained with the `dataikuapi.dssclient.DSSClient.list\_connections()` method:

§ client = DSSClient(host, apiKey)

§ dss\_connections = client.list\_connections()

§ prettyprinter.pprint(dss\_connections)

outputs

§ {   'filesystem\_managed': {   'allowManagedDatasets': True,

§ 'allowMirror': False,

§ 'allowWrite': True,

§ 'allowedGroups': [],

§ 'maxActivities': 0,

§ 'name': 'filesystem\_managed',

§ 'params': {   'root': '${dip.home}/managed\_datasets'},

§ 'type': 'Filesystem',

§ 'usableBy': 'ALL',

§ 'useGlobalProxy': True},

§ 'hdfs\_root':                  {    'allowManagedDatasets': True,

§ 'allowMirror': False,

§ 'allowWrite': True,

§ 'allowedGroups': [],

§ 'maxActivities': 0,

§ 'name': 'hdfs\_root',

§ 'params': {'database': 'dataik', 'root': '/'},

§ 'type': 'HDFS',

§ 'usableBy': 'ALL',

§ 'useGlobalProxy': False},

§ 'local\_postgress':    {    'allowManagedDatasets': True,

§ 'allowMirror': False,

§ 'allowWrite': True,

§ 'allowedGroups': [],

§ 'maxActivities': 0,

§ 'name': 'local\_postgress',

§ 'params': { 'db': 'testdb',

§ 'host': 'localhost',

§ 'password': 'admin',

§ 'port': '5432',

§ 'properties': {   },

§ 'user': 'admin'},

§ 'type': 'PostgreSQL',

§ 'usableBy': 'ALL',

§ 'useGlobalProxy': False},

§ ...

§ }

Connections can be added:

§ new\_connection\_params = {'db':'mysql\_test', 'host': 'localhost', 'password': 'admin', 'properties': [{'name': 'useSSL', 'value': 'true'}], 'user': 'admin'}

§ new\_connection = client.create\_connection('test\_connection', type='MySql', params=new\_connection\_params, usable\_by='ALLOWED', allowed\_groups=['administrators','data\_team'])

§ prettyprinter.pprint(client.list\_connections()['test\_connection'])

outputs

§ {   'allowManagedDatasets': True,

§ 'allowMirror': True,

§ 'allowWrite': True,

§ 'allowedGroups': ['data\_scientists'],

§ 'maxActivities': 0,

§ 'name': 'test\_connection',

§ 'params': {   'db': 'mysql\_test',

§ 'host': 'localhost',

§ 'password': 'admin',

§ 'properties': {   },

§ 'user': 'admin'},

§ 'type': 'MySql',

§ 'usableBy': 'ALLOWED',

§ 'useGlobalProxy': True}

To modify a connection, it is advised to first retrieve the connection definition with a `get\_definition()` call, alter the definition, and set it back into DSS:

§ connection\_definition = new\_connection.get\_definition()

§ connection\_definition['usableBy'] = 'ALL'

§ connection\_definition['allowWrite'] = False

§ new\_connection.set\_definition(connection\_definition)

§ prettyprinter.pprint(new\_connection.get\_definition())

outputs

§ {   'allowManagedDatasets': True,

§ 'allowMirror': True,

§ 'allowWrite': False,

§ 'allowedGroups': ['data\_scientists'],

§ 'maxActivities': 0,

§ 'name': 'test\_connection',

§ 'params': {   'db': 'mysql\_test',

§ 'host': 'localhost',

§ 'password': 'admin',

§ 'properties': {   },

§ 'user': 'admin'},

§ 'type': 'MySql',

§ 'usableBy': 'ALL',

§ 'useGlobalProxy': True}

Connections can be deleted through their handle:

§ connection = client.get\_connection('test\_connection')

§ connection.delete()

## Detailed examples[¶](https://developer.dataiku.com/latest/concepts-and-examples/connections.html#detailed-examples "Permalink to this heading")

This section contains more advanced examples on Connections.

### Mass-change filesystem Connections[¶](https://developer.dataiku.com/latest/concepts-and-examples/connections.html#mass-change-filesystem-connections "Permalink to this heading")

You can programmatically switch all Datasets of a Project from a given filesystem Connection to a different one, thus reproducing the “Change Connection” action available in the Dataiku Flow UI.

§ import dataiku

§ def mass\_change\_connection(project, origin\_conn, dest\_conn):

§ """Mass change dataset connections in a project (filesystem connections only)

§ """

§ all\_datasets = project.list\_datasets()

§ for d in all\_datasets():

§ ds = project.get\_dataset(d["name"])

§ ds\_def = ds.get\_definition()

§ if ds\_def["type"] == "Filesystem":

§ if ds\_def["params"]["connection"] == origin\_conn:

§ ds\_def["params"]["connection"] == dest\_conn

§ ds.set\_definition(ds\_def)

§ client = dataiku.api\_client()

§ project = client.get\_default\_project()

§ mass\_change\_connection(project, "FSCONN\_SOURCE", "FSCONN\_DEST")

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/connections.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dss.admin.DSSConnection`(client, name) | A connection on the DSS instance. |
