# Code envs[¶](https://developer.dataiku.com/latest/concepts-and-examples/code-envs.html#code-envs "Permalink to this heading")

The API offers methods to:

* Create code envs

* Read and write settings and packages of code envs

* Update code envs

* Reinstall

* Set code environment resources environment variables

## Creating a code env[¶](https://developer.dataiku.com/latest/concepts-and-examples/code-envs.html#creating-a-code-env "Permalink to this heading")

### Python 3.6 code env, with Jupyter support[¶](https://developer.dataiku.com/latest/concepts-and-examples/code-envs.html#python-3-6-code-env-with-jupyter-support "Permalink to this heading")

§ client = dataiku.api\_client()

§ # Create the code env

§ code\_env = client.create\_code\_env("PYTHON", "my\_code\_env\_name", "DESIGN\_MANAGED", {"pythonInterpreter": "PYTHON36"})

§ # Setup packages to install

§ definition = code\_env.get\_definition()

§ definition["desc"]["installCorePackages"] = True

§ definition["desc"]["installJupyterSupport"] = True

§ # We want to install 2 packages (tabulate and nameparser)

§ definition["specPackageList"] = "tabulate\nnameparser"

§ # Save the new settings

§ code\_env.set\_definition(definition)

§ # Actually perform the installation

§ code\_env.update\_packages()

§ code\_env.set\_jupyter\_support(True)

### Python 2.7 code env, without Jupyter support[¶](https://developer.dataiku.com/latest/concepts-and-examples/code-envs.html#python-2-7-code-env-without-jupyter-support "Permalink to this heading")

§ client = dataiku.api\_client()

§ # Create the code env

§ code\_env = client.create\_code\_env("PYTHON", "my\_code\_env\_name", "DESIGN\_MANAGED")

§ # Setup packages to install

§ definition = code\_env.get\_definition()

§ definition["desc"]["installCorePackages"] = True

§ # We want to install 2 packages (tabulate and nameparser)

§ definition["specPackageList"] = "tabulate\nnameparser"

§ # Save the new settings

§ code\_env.set\_definition(definition)

§ # Actually perform the installation

§ code\_env.update\_packages()

## Managing the code environment resources directory environment variables[¶](https://developer.dataiku.com/latest/concepts-and-examples/code-envs.html#managing-the-code-environment-resources-directory-environment-variables "Permalink to this heading")

These methods may only be called from a resource initialization script. See Managed code environment resources directory.

§ from dataiku.code\_env\_resources import clear\_all\_env\_vars

§ from dataiku.code\_env\_resources import delete\_env\_var

§ from dataiku.code\_env\_resources import get\_env\_var

§ from dataiku.code\_env\_resources import set\_env\_var

§ from dataiku.code\_env\_resources import set\_env\_path

§ # Delete all environment variables from the code environment runtime

§ clear\_all\_env\_vars()

§ # Set a raw environment variable for the code environment runtime

§ set\_env\_var("ENV\_VAR", "42")

§ # Set a relative path environment variable to be loaded at runtime

§ # (relative path with respect to the code env resources directory)

§ set\_env\_path("TFHUB\_CACHE\_DIR", "tensorflow")

§ # Get an environment variable from the code environment runtime

§ print("TFHUB\_CACHE\_DIR:", get\_env\_var("TFHUB\_CACHE\_DIR"))

§ # Delete an environment variable from the code environment runtime

§ delete\_env\_var("ENV\_VAR")

§ # Then download pre-trained models in the resources directory, e.g.

§ # for TensorFlow

§ # import tensorflow\_hub

§ # tensorflow\_hub.KerasLayer("https://tfhub.dev/google/imagenet/mobilenet\_v2\_140\_224/classification/4")

**(Advanced)** The method `dataiku.code\_env\_resources.fetch\_from\_backend` allows to fetch specific resources files or folders from the backend, when running in containerized execution. It is meant to be called in a python recipe/notebook, when the resources were not already copied or initialized for containerized execution at build time (see Code environment resources directory).

§ from dataiku.code\_env\_resources import fetch\_from\_backend

§ # Fetch resources files and folders from the backend

§ fetch\_from\_backend([

§ "pytorch/hub/checkpoints/fasterrcnn\_resnet50\_fpn\_coco-258fb6c6.pth",

§ "huggingface/",

§ ])

§ # Load pre-trained models as usual

## Detailed examples[¶](https://developer.dataiku.com/latest/concepts-and-examples/code-envs.html#detailed-examples "Permalink to this heading")

### Get Recipes using specific Code Environments[¶](https://developer.dataiku.com/latest/concepts-and-examples/code-envs.html#get-recipes-using-specific-code-environments "Permalink to this heading")

When editing a Code Environment you may want to assess which Code Recipe is using that environment and thus could be affected by the changes. The following code snippet allows you to get such a mapping:

§ import dataiku

§ def get\_instance\_default\_code\_env(client):

§ """Return the global default code envs (instance-level).

§ """

§ defaults = {}

§ general\_settings = client.get\_general\_settings()

§ for rcp\_type in [("python", "defaultPythonEnv"), ("r", "defaultREnv")]:

§ code\_env = general\_settings.settings["codeEnvs"].get(rcp\_type[1], None)

§ if code\_env:

§ defaults[rcp\_type[0]] = code\_env

§ else:

§ defaults[rcp\_type[0]] = "dss\_builtin"

§ return defaults

§ def get\_code\_env\_mapping(client, project):

§ """Return a dict mapping code-based items with their code envs.

§ """

§ rcp\_types = ["python", "r"]

§ mapping = {"python": [], "r": []}

§ env\_default = {}

§ settings = project.get\_settings()

§ project\_default\_modes = settings.get\_raw()["settings"]["codeEnvs"]

§ all\_recipes = project.list\_recipes()

§ for rcp\_type in rcp\_types:

§ if project\_default\_modes[rcp\_type]["mode"] == "USE\_BUILTIN\_MODE":

§ env\_default[rcp\_type] = "dss\_builtin"

§ if project\_default\_modes[rcp\_type]["mode"] == "INHERIT":

§ env\_default[rcp\_type] = get\_instance\_default\_code\_env(client).get(rcp\_type)

§ if project\_default\_modes[rcp\_type]["mode"] == "EXPLICIT\_ENV":

§ env\_default[rcp\_type] = project\_default\_modes[rcp\_type]["envName"]

§ recipes = [r for r in all\_recipes if r["type"] == rcp\_type]

§ for r in recipes:

§ name = r["name"]

§ env\_select = r["params"]["envSelection"]

§ if env\_select["envMode"] == "EXPLICIT\_ENV":

§ code\_env = env\_select["envName"]

§ else:

§ code\_env = env\_default[rcp\_type]

§ mapping[rcp\_type].append({"name": name, "code\_env": code\_env})

§ return mapping

§ client = dataiku.api\_client()

§ project = client.get\_default\_project()

§ mapping = get\_code\_env\_mapping(client, project)

§ print(mapping)

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/code-envs.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dss.admin.DSSCodeEnv`(client, ...) | A code env on the DSS instance. |
