# Code Studios[¶](https://developer.dataiku.com/latest/concepts-and-examples/code-studios.html#code-studios "Permalink to this heading")

The API offers methods to:

* Create and list code studios

* Start/stop them and trigger file synchronizations

For code studio templates, the API offers methods to:

* list code studio templates

* build them

## Build a code studio template[¶](https://developer.dataiku.com/latest/concepts-and-examples/code-studios.html#build-a-code-studio-template "Permalink to this heading")

§ client = dataiku.api\_client()

§ template\_id = "my\_template\_id"

§ # Obtain a handle on the code studio template

§ my\_template = client.get\_code\_studio\_template(template\_id)

§ # Build the template. This operation is asynchronous

§ build\_template = my\_template.build()

§ build\_template.wait\_for\_result()

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/code-studios.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dss.codestudio.DSSCodeStudioObject`(...) | A handle to manage a code studio object of a project |

| `dataikuapi.dss.codestudio.DSSCodeStudioObjectListItem`(...) | An item in a list of code studios. |

| `dataikuapi.dss.codestudio.DSSCodeStudioObjectSettings`(...) | Settings for the code studio object |

| `dataikuapi.dss.codestudio.DSSCodeStudioObjectStatus`(...) | Status of a code studio object |

| `dataikuapi.dss.admin.DSSCodeStudioTemplateListItem`(...) | An item in a list of code studio templates. |

| `dataikuapi.dss.admin.DSSCodeStudioTemplate`(...) | A handle to interact with a code studio template on the DSS instance |

| `dataikuapi.dss.admin.DSSCodeStudioTemplateSettings`(...) | The settings of a code studio template |
