# Clusters[¶](https://developer.dataiku.com/latest/concepts-and-examples/clusters.html#clusters "Permalink to this heading")

The API offers methods to:

* Start, stop or delete clusters

* Read and write settings of clusters

* Get the status of clusters

Clusters may be listed, created and obtained using methods of the `DSSClient`:

* list clusters: `list\_clusters()`

* obtain a handle on a cluster: `get\_cluster()`

* create a cluster: `create\_cluster()`

`DSSClusterSettings` is an opaque type and its content is specific to each cluster provider. It is therefore strongly advised to use scenario steps to create/start/delete clusters, as this will greatly help define a consistent configuration.

## Starting a managed cluster[¶](https://developer.dataiku.com/latest/concepts-and-examples/clusters.html#starting-a-managed-cluster "Permalink to this heading")

§ import logging

§ logger = logging.getLogger("my.package")

§ client = dataiku.api\_client()

§ cluster\_id = "my\_cluster\_id"

§ # Obtain a handle on the cluster

§ my\_cluster = client.get\_cluster(cluster\_id)

§ # Start the cluster. This operation is synchronous. An exception is thrown in case of error

§ try:

§ my\_cluster.start()

§ logger.info("Cluster {} started".format(cluster\_id))

§ except:

§ logger.exception("Could not start cluster: {}".format(e))

## Getting the status of a cluster[¶](https://developer.dataiku.com/latest/concepts-and-examples/clusters.html#getting-the-status-of-a-cluster "Permalink to this heading")

§ import logging

§ logger = logging.getLogger("my.package")

§ client = dataiku.api\_client()

§ cluster\_id = "my\_cluster\_id"

§ # Obtain a handle on the cluster

§ my\_cluster = client.get\_cluster(cluster\_id)

§ # Get status

§ status = my\_cluster.get\_status()

§ logger.info("Cluster status is {}".format(status))

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/clusters.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dss.admin.DSSCluster`(client, ...) | A handle to interact with a cluster on the DSS instance. |

| `dataikuapi.dss.admin.DSSClusterSettings`(...) | The settings of a cluster. |

| `dataikuapi.dss.admin.DSSClusterStatus`(...) | The status of a cluster. |
