# Discussions[¶](https://developer.dataiku.com/latest/concepts-and-examples/discussions.html#discussions "Permalink to this heading")

You can interact with the discussions on each DSS object through the API.

## Obtaining the discussions[¶](https://developer.dataiku.com/latest/concepts-and-examples/discussions.html#obtaining-the-discussions "Permalink to this heading")

The first step is always to retrieve a `DSSObjectDiscussions` object corresponding to the DSS object your manipulating. Generally, it’s through a method called `get\_object\_discussions`

§ # Get the discussions of a dataset

§ discussions = dataset.get\_object\_discussions()

§ # Get the discussion of a wiki article

§ discussions = wiki.get\_article("my article").get\_object\_discussions()

§ # Get the discussions of a project

§ discussions = project.get\_object\_discussions()

§ # ...

## List the discussions of an object[¶](https://developer.dataiku.com/latest/concepts-and-examples/discussions.html#list-the-discussions-of-an-object "Permalink to this heading")

§ for discussion in discussions.list\_discussions():

§ # Discussion is a DSSDiscussion object

§ print("Discussion with id: %s" % discussion.discussion\_id)

## Reading the messages of a discussion[¶](https://developer.dataiku.com/latest/concepts-and-examples/discussions.html#reading-the-messages-of-a-discussion "Permalink to this heading")

§ for message in discussion.get\_replies():

§ print("Message by author %s" % message.get\_author())

§ print("Message posted on %s" % message.get\_timestamp())

§ print("Message content: %s" % message.get\_text())

## Adding a new message to a discussion[¶](https://developer.dataiku.com/latest/concepts-and-examples/discussions.html#adding-a-new-message-to-a-discussion "Permalink to this heading")

§ discussion.add\_reply("hello world\n# This is Markdown")

## Creating a new discussion[¶](https://developer.dataiku.com/latest/concepts-and-examples/discussions.html#creating-a-new-discussion "Permalink to this heading")

§ new\_discussion = discussions.create\_discussion("Topic", "Hello, this is the message")

## Detailed examples[¶](https://developer.dataiku.com/latest/concepts-and-examples/discussions.html#detailed-examples "Permalink to this heading")

This section contains more advanced examples on discussions.

### Export discussions from a Project[¶](https://developer.dataiku.com/latest/concepts-and-examples/discussions.html#export-discussions-from-a-project "Permalink to this heading")

You can programmatically retrieve all discussion messages from various “commentable” items in a Project.

§ import dataiku

§ def get\_discussions\_from\_object(object\_handle):

§ """Return all discussion messages from a commentable object.

§ """

§ disc\_data = []

§ discussions = object\_handle.get\_object\_discussions()

§ for disc in discussions.list\_discussions():

§ disc\_content = {}

§ disc\_content["topic"] = disc.get\_metadata()["topic"]

§ msg\_list = []

§ for msg in disc.get\_replies():

§ msg\_content = {}

§ msg\_content["author"] = msg.get\_author()

§ msg\_content["ts"] = msg.get\_timestamp()

§ msg\_content["text"] = msg.get\_text()

§ msg\_list.append(msg\_content)

§ disc\_content["messages"] = msg\_list

§ disc\_data.append(disc\_content)

§ return disc\_data

§ def export\_project\_discussions(project):

§ """Return all discussion data for a given Project.

§ """

§ proj\_disc = {}

§ dispatch = {

§ "datasets": {

§ "f\_list": project.list\_datasets,

§ "f\_get": project.get\_dataset

§ },

§ "recipes": {

§ "f\_list": project.list\_recipes,

§ "f\_get": project.get\_recipe

§ },

§ "scenarios": {

§ "f\_list": project.list\_scenarios,

§ "f\_get": project.get\_scenario

§ },

§ "managed\_folders": {

§ "f\_list": project.list\_managed\_folders,

§ "f\_get": project.get\_managed\_folder

§ }

§ }

§ for obj\_type, funcs in dispatch.items():

§ obj\_disc = []

§ for item in funcs["f\_list"]():

§ disc = {}

§ disc["name"] = item["name"]

§ obj\_handle = funcs["f\_get"](item["name"])

§ disc["discussions"] = get\_discussions\_from\_object(obj\_handle)

§ obj\_disc.append(disc)

§ proj\_disc[obj\_type] = obj\_disc

§ # Special case: project discussions

§ proj\_disc["project"] = get\_discussions\_from\_object(project)

§ # Special case: wiki

§ wiki\_disc = []

§ articles = project.get\_wiki().list\_articles()

§ for art in articles:

§ art\_disc = {}

§ art\_disc["article\_id"] = art.article\_id

§ art\_disc["discussions"] = get\_discussions\_from\_object(art)

§ wiki\_disc.append(art\_disc)

§ proj\_disc["wiki"] = wiki\_disc

§ return proj\_disc

§ client = dataiku.api\_client()

§ project = client.get\_default\_project()

§ discussions = export\_project\_discussions(project)

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/discussions.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dss.discussion.DSSObjectDiscussions`(...) | A handle to manage discussions on a DSS object |

| `dataikuapi.dss.discussion.DSSDiscussion`(...) | Do not call directly, use `dataikuapi.dss.discussion.DSSObjectDiscussions.get\_discussion()` |

| `dataikuapi.dss.discussion.DSSDiscussionReply`(...) | A read-only handle to access a discussion reply |
