# Authentication information and impersonation[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-authinfo.html#authentication-information-and-impersonation "Permalink to this heading")

## Introduction[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-authinfo.html#introduction "Permalink to this heading")

From any Python code, it is possible to retrieve information about the user or API key currently running this code.

This can be used:

* From code running outside of Dataiku Govern, simply to retrieve details of the current API key

Furthermore, the API provides the ability, from a set of HTTP headers, to identify the user represented by these headers.

## Code samples[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-authinfo.html#code-samples "Permalink to this heading")

### Getting your own login information[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-authinfo.html#getting-your-own-login-information "Permalink to this heading")

§ auth\_info = client.get\_auth\_info()

§ # auth\_info is a dict which contains at least a "authIdentifier" field, which is the login for a user

§ print("User running this code is %s" % auth\_info["authIdentifier"])

### Impersonating another user[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-authinfo.html#impersonating-another-user "Permalink to this heading")

As a Dataiku Govern administrator, it can be useful to be able to perform API calls on behalf of another user.

§ user = client.get\_user("the\_user\_to\_impersonate")

§ client\_as\_user = user.get\_client\_as()

§ # All calls done using `client\_as\_user` will appear as being performed by `the\_user\_to\_impersonate` and will inherit

§ # its permissions

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-authinfo.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.GovernClient.get\_auth\_info`() | Returns various information about the user currently authenticated using this instance of the API client. |
