# Govern Blueprints and Blueprint versions[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-blueprints-blueprint-versions.html#govern-blueprints-and-blueprint-versions "Permalink to this heading")

Blueprint versions are templates describing the items in Dataiku Govern. Several blueprint versions are gathered within the same Blueprint which holds a logical concept. Note: to learn more about them, go to the Dataiku Govern definitions page.

## List all blueprints[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-blueprints-blueprint-versions.html#list-all-blueprints "Permalink to this heading")

§ import dataikuapi

§ host = "http(s)://DSS\_HOST:DSS\_PORT"

§ apiKey = "Your API key secret"

§ client = dataikuapi.GovernClient(host, apiKey)

§ # List the blueprints for which the API key has access

§ client.list\_blueprints()

## Reference API doc[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-blueprints-blueprint-versions.html#reference-api-doc "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.govern.blueprint.GovernBlueprintListItem`(...) | An item in a list of blueprints. |

| `dataikuapi.govern.blueprint.GovernBlueprint`(...) | A handle to read a blueprint on the Govern instance. |

| `dataikuapi.govern.blueprint.GovernBlueprintDefinition`(...) | The definition of a blueprint. |

| `dataikuapi.govern.blueprint.GovernBlueprintVersionListItem`(...) | An item in a list of blueprint versions. |

| `dataikuapi.govern.blueprint.GovernBlueprintVersion`(...) | A handle to interact with a blueprint version on the Govern instance. |

| `dataikuapi.govern.blueprint.GovernBlueprintVersionTrace`(...) | The trace of a blueprint version containing information about its lineage and its status. |

| `dataikuapi.govern.blueprint.GovernBlueprintVersionDefinition`(...) | The definition of a blueprint version. |
