# Govern Custom Pages Handler[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-custom-pages-handler.html#govern-custom-pages-handler "Permalink to this heading")

Admins can manage custom pages.

## Retrieve the definition of a custom page[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-custom-pages-handler.html#retrieve-the-definition-of-a-custom-page "Permalink to this heading")

§ import dataikuapi

§ host = "http(s)://DSS\_HOST:DSS\_PORT"

§ apiKey = "Your API key secret"

§ client = dataikuapi.GovernClient(host, apiKey)

§ # retrieve the custom pages handler

§ custom\_pages\_handler = client.get\_custom\_pages\_handler()

§ # get a custom page by its ID

§ custom\_page = custom\_pages\_handler.get\_custom\_page('cp.cust\_page\_1')

§ # get its definition

§ custom\_page\_def = custom\_page.get\_definition()

§ # print its definition

§ print(custom\_page\_def.get\_raw())

## Reference API doc[¶](https://developer.dataiku.com/latest/concepts-and-examples/govern/govern-custom-pages-handler.html#reference-api-doc "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.govern.admin\_custom\_pages\_handler.GovernAdminCustomPagesHandler`(client) | Handle to edit the custom pages Do not create this directly, use `get\_custom\_pages\_handler()` |

| `dataikuapi.govern.admin\_custom\_pages\_handler.GovernAdminCustomPageListItem`(...) | An item in a list of custom pages. |

| `dataikuapi.govern.admin\_custom\_pages\_handler.GovernAdminCustomPage`(...) | A handle to interact with a custom page as an administrator. |

| `dataikuapi.govern.admin\_custom\_pages\_handler.GovernAdminCustomPageDefinition`(...) | The definition of a custom page. |
