# Recipes[¶](https://developer.dataiku.com/latest/concepts-and-examples/recipes.html#recipes "Permalink to this heading")

This page lists usage examples for performing various operations with recipes through Dataiku Python API. In all examples, `project` is a `dataikuapi.dss.project.DSSProject` handle, obtained using `client.get\_project()` or `client.get\_default\_project()`

## Basic operations[¶](https://developer.dataiku.com/latest/concepts-and-examples/recipes.html#basic-operations "Permalink to this heading")

### Listing recipes[¶](https://developer.dataiku.com/latest/concepts-and-examples/recipes.html#listing-recipes "Permalink to this heading")

§ recipes = project.list\_recipes()

§ # Returns a list of DSSRecipeListItem

§ for recipe in recipes:

§ # Quick access to main information in the recipe list item

§ print("Name: %s" % recipe.name)

§ print("Type: %s" % recipe.type)

§ print("Tags: %s" % recipe.tags) # Returns a list of strings

§ # You can also use the list item as a dict of all available recipe information

§ print("Raw: %s" % recipe)

### Deleting a recipe[¶](https://developer.dataiku.com/latest/concepts-and-examples/recipes.html#deleting-a-recipe "Permalink to this heading")

§ recipe = project.get\_recipe('myrecipe')

§ recipe.delete()

### Modifying tags for a recipe[¶](https://developer.dataiku.com/latest/concepts-and-examples/recipes.html#modifying-tags-for-a-recipe "Permalink to this heading")

§ recipe = project.get\_recipe('myrecipe')

§ settings = dataset.get\_settings()

§ print("Current tags are %s" % settings.tags)

§ # Change the tags

§ settings.tags = ["newtag1", "newtag2"]

§ # If we changed the settings, we must save

§ settings.save()

## Recipe creation[¶](https://developer.dataiku.com/latest/concepts-and-examples/recipes.html#recipe-creation "Permalink to this heading")

Please see Flow creation and management

## Recipe status[¶](https://developer.dataiku.com/latest/concepts-and-examples/recipes.html#recipe-status "Permalink to this heading")

You can compute the status of the recipe, which also provides you with the engine information.

### Find the engine used to run a recipe[¶](https://developer.dataiku.com/latest/concepts-and-examples/recipes.html#find-the-engine-used-to-run-a-recipe "Permalink to this heading")

§ recipe = project.get\_recipe("myrecipe")

§ status = recipe.get\_status()

§ print(status.get\_selected\_engine\_details())

### Check if a recipe is valid[¶](https://developer.dataiku.com/latest/concepts-and-examples/recipes.html#check-if-a-recipe-is-valid "Permalink to this heading")

`get\_status()` calls the validation code of the recipe

§ recipe = project.get\_recipe("myrecipe")

§ status = recipe.get\_status()

§ print(status.get\_selected\_engine\_details())

### Find the engines for all recipes of a certain type[¶](https://developer.dataiku.com/latest/concepts-and-examples/recipes.html#find-the-engines-for-all-recipes-of-a-certain-type "Permalink to this heading")

This example shows how to filter a list, obtain `DSSRecipe` objects for the list items, and getting their status

§ for list\_item in project.list\_recipes():

§ if list\_item.type == "grouping":

§ recipe = list\_item.to\_recipe()

§ engine = recipe.get\_status().get\_selected\_engine\_details()["type"]

§ print("Recipe %s uses engine %s" % (recipe.name, engine))

## Recipe settings[¶](https://developer.dataiku.com/latest/concepts-and-examples/recipes.html#recipe-settings "Permalink to this heading")

When you use `get\_settings()` on a recipe, you receive a settings object whose class depends on the recipe type. Please see below for the possible types.

### Checking if a recipe uses a particular dataset as input[¶](https://developer.dataiku.com/latest/concepts-and-examples/recipes.html#checking-if-a-recipe-uses-a-particular-dataset-as-input "Permalink to this heading")

§ recipe = project.get\_recipe("myrecipe")

§ settings = recipe.get\_settings()

§ print("Recipe %s uses input:%s" % (recipe.name, settings.has\_input("mydataset"))

### Replacing an input of a recipe[¶](https://developer.dataiku.com/latest/concepts-and-examples/recipes.html#replacing-an-input-of-a-recipe "Permalink to this heading")

§ recipe = project.get\_recipe("myrecipe")

§ settings = recipe.get\_settings()

§ settings.replace\_input("old\_input", "new\_input")

§ settings.save()

### Setting the code env of a code recipe[¶](https://developer.dataiku.com/latest/concepts-and-examples/recipes.html#setting-the-code-env-of-a-code-recipe "Permalink to this heading")

§ recipe = project.get\_recipe("myrecipe")

§ settings = recipe.get\_settings()

§ # Use this to set the recipe to inherit the project's code env

§ settings.set\_code\_env(inherit=True)

§ # Use this to set the recipe to use a specific code env

§ settings.set\_code\_env(code\_env="myenv")

§ settings.save()

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/recipes.html#reference-documentation "Permalink to this heading")

|  |  |

| --- | --- |

| `dataikuapi.dss.recipe.DSSRecipe`(client, ...) | A handle to an existing recipe on the DSS instance. |

| `dataikuapi.dss.recipe.GroupingRecipeCreator`(...) | Create a Group recipe |

| `dataikuapi.dss.recipe.JoinRecipeCreator`(...) | Create a Join recipe |

| `dataikuapi.dss.recipe.StackRecipeCreator`(...) | Create a Stack recipe |

| `dataikuapi.dss.recipe.WindowRecipeCreator`(...) | Create a Window recipe |

| `dataikuapi.dss.recipe.SyncRecipeCreator`(...) | Create a Sync recipe |

| `dataikuapi.dss.recipe.SamplingRecipeCreator`(...) | Create a Sample/Filter recipe |

| `dataikuapi.dss.recipe.SQLQueryRecipeCreator`(...) | Create a SQL query recipe |

| `dataikuapi.dss.recipe.CodeRecipeCreator`(...) |  |

| `dataikuapi.dss.recipe.SplitRecipeCreator`(...) | Create a Split recipe |

| `dataikuapi.dss.recipe.EvaluationRecipeCreator`(...) | Builder for the creation of a new "Evaluate" recipe, from an input dataset, with an input saved model identifier |
