# Scenarios (in a scenario)[¶](https://developer.dataiku.com/latest/concepts-and-examples/scenarios-inside.html#scenarios-in-a-scenario "Permalink to this heading")

This is the documentation of the API for use in scenarios.

Warning

This API can only be used within a scenario in order to run steps and report on progress of the current scenario.

If you want to control scenarios, please see Scenarios

These functions can be used both for “Execute Python code” steps in steps-based scenarios, and for full Python scenarios

A quick description of Python scenarios can be found in Definitions. More details and usage samples are also available in Custom scenarios

The Scenario is the main class you’ll use to interact with DSS in your “Execute Python code” steps and Python scenarios.

## Detailed examples[¶](https://developer.dataiku.com/latest/concepts-and-examples/scenarios-inside.html#detailed-examples "Permalink to this heading")

### Set Scenario step timeout[¶](https://developer.dataiku.com/latest/concepts-and-examples/scenarios-inside.html#set-scenario-step-timeout "Permalink to this heading")

There is no explicit timeout functionality for a Build step within a Scenario. A common question is how to setup a timeout for a scenario or scenario step to avoid situations where a scenario gets stuck/hung in a running state indefinitely.

You can implement it using the Dataiku Python API. The same scenario step can be re-written as a custom Python step, in which case you can add additional Python code to implement a timeout.

Here is a code sample that you can try:

§ ###########################################################################################

§ # !! CUSTOM SCENARIO EXAMPLE !! #

§ # See https://doc.dataiku.com/dss/latest/scenarios/custom\_scenarios.html for more details #

§ ###########################################################################################

§ import time

§ import dataiku

§ from dataiku.scenario import Scenario, BuildFlowItemsStepDefHelper

§ from dataikuapi.dss.future import DSSFuture

§ TIMEOUT\_SECONDS = 3600

§ s = Scenario()

§ # Replace this commented block by your Scenario steps

§ # Example: build a Dataset

§ step\_handle = s.build\_dataset("your\_dataset\_name", asynchronous=True)

§ start = time.time()

§ while not step\_handle.is\_done():

§ end = time.time()

§ print("Duration: {}s".format(end-start))

§ if end - start > TIMEOUT\_SECONDS:

§ f = DSSFuture(dataiku.api\_client(), step\_handle.future\_id)

§ f.abort()

§ raise Exception("Scenario was aborted because it took too much time.")

## Reference documentation[¶](https://developer.dataiku.com/latest/concepts-and-examples/scenarios-inside.html#reference-documentation "Permalink to this heading")
