# Use Custom Static Files (Javascript, CSS) in a Webapp[¶](https://developer.dataiku.com/latest/tutorials/webapps/standard/custom-static-files-kb/index.html#use-custom-static-files-javascript-css-in-a-webapp "Permalink to this heading")

In addition to the JavaScript or CSS you type in a standard webapp, you may want to use certain code libraries.

Dataiku DSS comes with some embedded standard JS libraries (jQuery, boostrap, etc). Just go to the “Settings” tab of the webapp editor to activate them.

If the library you are looking for is not available in DSS, a quick way to load it, if your library is already hosted, is to simply link from your HTML:

§ <script type="text/javascript" src='https://www.gstatic.com/charts/loader.js'></script>

Dataiku DSS also has a “static” folder where you can place static content (JavaScript, CSS, images) that will be served by DSS and available to your webapps.

There are two ways to move files to that folder:

* using the web interface or

* using the command line.

## Import Libraries using the Graphical Interface[¶](https://developer.dataiku.com/latest/tutorials/webapps/standard/custom-static-files-kb/index.html#import-libraries-using-the-graphical-interface "Permalink to this heading")

If you have admin rights on your DSS instance, you can click on the Application menu near the top-right corner. Select **Global Shared Code** and navigate to the “Static Web Resources” tab on the right.

You can either create and edit files within Dataiku DSS, or upload your files.

## Import Libraries using the Command Line[¶](https://developer.dataiku.com/latest/tutorials/webapps/standard/custom-static-files-kb/index.html#import-libraries-using-the-command-line "Permalink to this heading")

If you have many files to import, you may want to use the command line. Here is how:

* Navigate to the DSS Data Directory.

* Check for the presence of a `local/static` directory. Create it if needed. Inside a terminal, enter:

§ mkdir -p local/static

* Copy your static files into this directory. For instance, you might copy your team’s CSS and JavaScript common files.

## Using Static Files in your Webapp[¶](https://developer.dataiku.com/latest/tutorials/webapps/standard/custom-static-files-kb/index.html#using-static-files-in-your-webapp "Permalink to this heading")

Once they are in, you can use the static files from the HTML code of your webapp as in the following example. (Note that there is a ‘/’ before “local”).

§ <script type="text/javascript" src="/local/static/my-team.js" />

§ <link rel="stylesheet" href="/local/static/my-team.css" />

§ <img src="/local/static/my-image.jpg" />

That’s it! You can now use your favorite Javascript or CSS libs in Dataiku DSS!

Tip

A word of further explanation: This works thanks to `DATA\_DIR/nginx/conf/nginx.conf`, which maps `/local/static/` to `dss-data-dir/local/static/`.
