# User Isolation[¶](https://doc.dataiku.com/dss/latest/user-isolation/index.html#user-isolation "Permalink to this headline")

Note

User Isolation Framework was previously called Multi-User-Security.

Note

If using Dataiku Cloud Stacks installation, User Isolation is automatically managed for you, and you do not need to follow these instructions

On an out-of-the-box installation of DSS, every action performed by DSS is performed as a single account on the host machine. This account which runs the DSS service is called the `dssuser`. For example, when a DSS end-user executes a code recipe, it runs as the UNIX `dssuser`

Similarly:

* Every action performed on a Hadoop cluster is performed by the `dssuser` service account. When a DSS end-user executes an Hadoop/Spark recipe or notebook on a Hadoop cluster, it runs on the cluster as the Hadoop `dssuser`.

* Every action performed on Kubernetes is initialized through the `dssuser` service account

* Actions performed on external databases use the credentials configured in the database connection.

This default behavior has several limitations:

* There is a lack of traceability on the Hadoop clusters to identify which user performed which action.

* If the DSS end-user is hostile and has the permission to execute “unsafe” code, he can run arbitrary code as UNIX `dssuser` and modify the DSS configuration

DSS features a set of mechanisms to isolate code which can be controlled by the user, so as to guarantee both traceability and inability for a hostile user to attack the `dssuser`. Together, these mechanisms form the *User Isolation Framework*.

The User Isolation Framework is not a single technology but a set of capabilities that permit isolation depending on the context. Most of the components of the User Isolation Framework imply that DSS *impersonates* the end-user and runs all user-controlled code under different identities than `dssuser`.

This documentation includes a number of reference architectures showing common deployments of the various UIF components.

Note

The User Isolation Framework requires an Enterprise Edition license of DSS.

* Capabilities of User Isolation Framework

* Concepts

+ The fundamental layer

+ Means of isolation

+ Identity mapping

* Prerequisites and limitations

+ Prerequisites

- Local machine

- Hadoop

- LDAP

- DSS

- Required information

+ Limitations

- Unsafe features

- HDFS datasets

* Initial Setup

+ Prerequisites and required information

+ Perform a regular DSS installation

+ Initialize UIF

- Additional setup for local filesystem access

+ Configure filesystem access on the DSS folders

+ Configure identity mapping

* Troubleshooting

+ sudo failed (exit code 1) when UIF is enabled and devtoolset-8 is installed

* Reference architectures

+ Local-code only

+ Setup with Cloudera

- The two modes

- Prerequisites and required information

- Common setup

- Sentry-mode

* Assumptions

* Configure your Cloudera cluster

+ Do it with Cloudera Manager

+ Setup Sentry

+ Additional setup for Impala

+ Additional setup for encrypted HDFS filesystems

* Setup driver for Impala

* Setup HDFS connections in DSS

* Configure identity mapping

* Setup Hive and Impala access

* Authorization models

+ One DSS connection per database

+ One database per DSS project, multiple databases per DSS connection

+ More complex setups

- DSS-ACL-synchronization-mode

* Configure your Cloudera cluster

+ Do it with Cloudera Manager

+ Additional setup for Impala

+ Additional setup for encrypted HDFS filesystems

* Setup driver for Impala

* Configure identity mapping

* Setup Hive and Impala access

* Initialize ACLs on HDFS connections

- Validate behavior

- Operations (Sentry mode)

* Overview

* Adding a project

* Adding/Removing a user in a group

* Adding access to a group

* Removing access from a group

* Interaction with externally-managed data

+ Existing Hive table

+ Synchronized Hive table

- Operations (ACL synchronization mode)

* Overview

* Adding a project

* Adding a user to a group

* Removing a user from a group

* Adding access to a group

* Removing access from a group

* Interaction with externally-managed data

+ Existing Hive table

+ Synchronized Hive table

+ Setup with Hortonworks Data Platform

- The two modes

- Prerequisites and required information

- Common setup

- Ranger-mode

* Assumptions

* Configure your cluster

+ With Ambari

+ Setup Ranger

+ Additional setup for encrypted HDFS filesystems

* Setup HDFS connections in DSS

* Configure identity mapping

* Setup Hive access

* Authorization models

+ One DSS connection per database

+ One database per DSS project, multiple databases per DSS connection

+ More complex setups

- DSS-ACL-synchronization-mode

* Configure your cluster

+ With Ambari

+ Setup Ranger

+ Additional setup for encrypted HDFS filesystems

* Configure identity mapping

* Setup Hive access

* Initialize ACLs on HDFS connections

- Validate behavior

- Operations (Ranger mode)

* Overview

* Adding a project

* Adding/Removing a user in a group

* Adding / Removing access to a group

* Interaction with externally-managed data

+ Existing Hive table

+ Synchronized Hive table

- Operations (ACL synchronization mode)

* Overview

* Adding a project

* Adding a user to a group

* Removing a user from a group

* Adding access to a group

* Removing access from a group

* Interaction with externally-managed data

+ Existing Hive table

+ Synchronized Hive table

+ Setup with Kubernetes

- Initial setup

- Common setup

- Running regular workloads

- Running Spark workloads

* One-namespace-per-user setup

* One-namespace-per-team setup

* Details of UIF capabilities

+ Local code isolation

+ Hadoop Impersonation (HDFS, YARN, Hive, Impala)

- Interaction with HDFS

- Interaction with Hive

- Interaction with Impala

- Interaction with Spark on YARN

* Architecture

* Hive Metastore

+ Workload isolation on Kubernetes

- Running regular workloads

- Running Spark workloads

+ Impersonation on Oracle

* Advanced topics

+ Configuration of the local security

- What are the sudo authorizations?

- Configuration of the local security module

* Splitted DSS datadirs

+ HDFS datasets data structure
