# Using ggvis[¶](https://doc.dataiku.com/dss/latest/R/ggvis.html#using-ggvis "Permalink to this headline")

ggvis is a data visualization package for R

For more information, see http://ggvis.rstudio.com/

## Installing ggvis[¶](https://doc.dataiku.com/dss/latest/R/ggvis.html#installing-ggvis "Permalink to this headline")

### Installing the ggvis package[¶](https://doc.dataiku.com/dss/latest/R/ggvis.html#installing-the-ggvis-package "Permalink to this headline")

The ggvis package is not installed by default. The recommended way to install it is to use a code environment

See how to install R packages

* For a regular R environment, you need to install the `ggvis` package

* If you are using a Conda environment, you can also choose instead to install in the Conda section the `r-ggvis` package.

### Installing the frontend dependencies[¶](https://doc.dataiku.com/dss/latest/R/ggvis.html#installing-the-frontend-dependencies "Permalink to this headline")

To work, ggvis first needs some frontend libraries, that need to be preinstalled once.

To install the dependencies, open a R notebook and run

§ library(dataiku)

§ dkuInstallGgvisDependenciesOnce()

Warning

It is not possible to run this if your DSS instance has the User Isolation Framework enabled.

In that case, your DSS administrator needs to run this from a command-line ./bin/R prompt, after setting the DIP\_HOME env variable to the location of the DSS data directory

## Displaying charts in a Jupyter notebook[¶](https://doc.dataiku.com/dss/latest/R/ggvis.html#displaying-charts-in-a-jupyter-notebook "Permalink to this headline")

ggvis charts will not work properly if you only enter it in a Jupyter notebook

Instead, use the `dkuDisplayGgvis` method.

For example; to display the first example in the ggvis documentation:

§ library(dataiku)

§ library(ggvis)

§ # Prepare the chart

§ chart <- mtcars %>% ggvis(~wt, ~mpg) %>% layer\_points()

§ # And display it

§ dkuDisplayGgvis(Line)

## Displaying charts on a dashboard[¶](https://doc.dataiku.com/dss/latest/R/ggvis.html#displaying-charts-on-a-dashboard "Permalink to this headline")

googleVis charts generated using R code can be shared on a DSS dashboard using the “static insights” system.

Each chart can become a single insight in the dashboard.

To do so, create static insights

§ # Prepare the chart

§ chart <- mtcars %>% ggvis(~wt, ~mpg) %>% layer\_points()

§ # Save it as an insight

§ dkuSaveGgvisInsight("my-ggvis-plot", chart)

From the Dashboard, you can then add a new “Static” insight, select the `my-ggvis-plot` insight

Plots can be donwloaded in SVG or PNG format

### Refreshing charts on a dashboard[¶](https://doc.dataiku.com/dss/latest/R/ggvis.html#refreshing-charts-on-a-dashboard "Permalink to this headline")

You can refresh the charts automatically on a dashboard by using a scenario to re-run the above piece of code.

This call to `dkuSaveGgvisInsight` code can be:

* In a DSS recipe (use a regular “Build” scenario step)

* In a Jupyter notebook (use a “Export notebook” scenario step)
